/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.TermMatchesIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.PriorityQueue;

final class DisjunctionMatchesIterator
implements MatchesIterator {
    private final PriorityQueue<MatchesIterator> queue;
    private boolean started = false;

    static MatchesIterator fromTerms(LeafReaderContext context2, int doc, String field, List<Term> terms) throws IOException {
        Objects.requireNonNull(field);
        for (Term term : terms) {
            if (Objects.equals(field, term.field())) continue;
            throw new IllegalArgumentException("Tried to generate iterator from terms in multiple fields: expected [" + field + "] but got [" + term.field() + "]");
        }
        return DisjunctionMatchesIterator.fromTermsEnum(context2, doc, field, DisjunctionMatchesIterator.asBytesRefIterator(terms));
    }

    private static BytesRefIterator asBytesRefIterator(final List<Term> terms) {
        return new BytesRefIterator(){
            int i = 0;

            @Override
            public BytesRef next() {
                if (this.i >= terms.size()) {
                    return null;
                }
                return ((Term)terms.get(this.i++)).bytes();
            }
        };
    }

    static MatchesIterator fromTermsEnum(LeafReaderContext context2, int doc, String field, BytesRefIterator terms) throws IOException {
        Objects.requireNonNull(field);
        ArrayList<MatchesIterator> mis = new ArrayList<MatchesIterator>();
        Terms t = context2.reader().terms(field);
        if (t == null) {
            return null;
        }
        TermsEnum te = t.iterator();
        PostingsEnum reuse = null;
        BytesRef term = terms.next();
        while (term != null) {
            if (te.seekExact(term)) {
                PostingsEnum pe = te.postings(reuse, 56);
                if (pe.advance(doc) == doc) {
                    mis.add(new TermMatchesIterator(pe));
                    reuse = null;
                } else {
                    reuse = pe;
                }
            }
            term = terms.next();
        }
        return DisjunctionMatchesIterator.fromSubIterators(mis);
    }

    static MatchesIterator fromSubIterators(List<MatchesIterator> mis) throws IOException {
        if (mis.size() == 0) {
            return null;
        }
        if (mis.size() == 1) {
            return mis.get(0);
        }
        return new DisjunctionMatchesIterator(mis);
    }

    private DisjunctionMatchesIterator(List<MatchesIterator> matches) throws IOException {
        this.queue = new PriorityQueue<MatchesIterator>(matches.size()){

            @Override
            protected boolean lessThan(MatchesIterator a, MatchesIterator b) {
                return a.startPosition() < b.startPosition() || a.startPosition() == b.startPosition() && a.endPosition() < b.endPosition() || a.startPosition() == b.startPosition() && a.endPosition() == b.endPosition();
            }
        };
        for (MatchesIterator mi : matches) {
            if (!mi.next()) continue;
            this.queue.add(mi);
        }
    }

    @Override
    public boolean next() throws IOException {
        if (!this.started) {
            this.started = true;
            return true;
        }
        if (!this.queue.top().next()) {
            this.queue.pop();
        }
        if (this.queue.size() > 0) {
            this.queue.updateTop();
            return true;
        }
        return false;
    }

    @Override
    public int startPosition() {
        return this.queue.top().startPosition();
    }

    @Override
    public int endPosition() {
        return this.queue.top().endPosition();
    }

    @Override
    public int startOffset() throws IOException {
        return this.queue.top().startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.queue.top().endOffset();
    }
}

