/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.InfoStream;

final class DocumentsWriterDeleteQueue
implements Accountable {
    private volatile Node<?> tail;
    private final DeleteSlice globalSlice;
    private final BufferedUpdates globalBufferedUpdates;
    final ReentrantLock globalBufferLock = new ReentrantLock();
    final long generation;
    private final AtomicLong nextSeqNo;
    private final InfoStream infoStream;
    long maxSeqNo = Long.MAX_VALUE;

    DocumentsWriterDeleteQueue(InfoStream infoStream) {
        this(infoStream, 0L, 1L);
    }

    DocumentsWriterDeleteQueue(InfoStream infoStream, long generation, long startSeqNo) {
        this(infoStream, new BufferedUpdates("global"), generation, startSeqNo);
    }

    DocumentsWriterDeleteQueue(InfoStream infoStream, BufferedUpdates globalBufferedUpdates, long generation, long startSeqNo) {
        this.infoStream = infoStream;
        this.globalBufferedUpdates = globalBufferedUpdates;
        this.generation = generation;
        this.nextSeqNo = new AtomicLong(startSeqNo);
        this.tail = new Node<Object>(null);
        this.globalSlice = new DeleteSlice(this.tail);
    }

    long addDelete(Query ... queries) {
        long seqNo = this.add(new QueryArrayNode(queries));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    long addDelete(Term ... terms) {
        long seqNo = this.add(new TermArrayNode(terms));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    long addDocValuesUpdates(DocValuesUpdate ... updates) {
        long seqNo = this.add(new DocValuesUpdatesNode(updates));
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    static Node<Term> newNode(Term term) {
        return new TermNode(term);
    }

    static Node<DocValuesUpdate[]> newNode(DocValuesUpdate ... updates) {
        return new DocValuesUpdatesNode(updates);
    }

    long add(Node<?> deleteNode, DeleteSlice slice) {
        long seqNo = this.add(deleteNode);
        slice.sliceTail = deleteNode;
        assert (slice.sliceHead != slice.sliceTail) : "slice head and tail must differ after add";
        this.tryApplyGlobalSlice();
        return seqNo;
    }

    synchronized long add(Node<?> newNode) {
        this.tail.next = newNode;
        this.tail = newNode;
        return this.getNextSequenceNumber();
    }

    boolean anyChanges() {
        this.globalBufferLock.lock();
        try {
            boolean bl = this.globalBufferedUpdates.any() || !this.globalSlice.isEmpty() || this.globalSlice.sliceTail != this.tail || this.tail.next != null;
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    void tryApplyGlobalSlice() {
        if (this.globalBufferLock.tryLock()) {
            try {
                if (this.updateSliceNoSeqNo(this.globalSlice)) {
                    this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
                }
            }
            finally {
                this.globalBufferLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrozenBufferedUpdates freezeGlobalBuffer(DeleteSlice callerSlice) throws IOException {
        this.globalBufferLock.lock();
        Node<?> currentTail = this.tail;
        if (callerSlice != null) {
            callerSlice.sliceTail = currentTail;
        }
        try {
            if (this.globalSlice.sliceTail != currentTail) {
                this.globalSlice.sliceTail = currentTail;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            if (this.globalBufferedUpdates.any()) {
                FrozenBufferedUpdates packet = new FrozenBufferedUpdates(this.infoStream, this.globalBufferedUpdates, null);
                this.globalBufferedUpdates.clear();
                FrozenBufferedUpdates frozenBufferedUpdates = packet;
                return frozenBufferedUpdates;
            }
            FrozenBufferedUpdates frozenBufferedUpdates = null;
            return frozenBufferedUpdates;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    DeleteSlice newSlice() {
        return new DeleteSlice(this.tail);
    }

    synchronized long updateSlice(DeleteSlice slice) {
        long seqNo = this.getNextSequenceNumber();
        if (slice.sliceTail != this.tail) {
            slice.sliceTail = this.tail;
            seqNo = -seqNo;
        }
        return seqNo;
    }

    boolean updateSliceNoSeqNo(DeleteSlice slice) {
        if (slice.sliceTail != this.tail) {
            slice.sliceTail = this.tail;
            return true;
        }
        return false;
    }

    public int numGlobalTermDeletes() {
        return this.globalBufferedUpdates.numTermDeletes.get();
    }

    void clear() {
        this.globalBufferLock.lock();
        try {
            Node<?> currentTail = this.tail;
            this.globalSlice.sliceTail = currentTail;
            this.globalSlice.sliceHead = this.globalSlice.sliceTail;
            this.globalBufferedUpdates.clear();
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    private boolean forceApplyGlobalSlice() {
        this.globalBufferLock.lock();
        Node<?> currentTail = this.tail;
        try {
            if (this.globalSlice.sliceTail != currentTail) {
                this.globalSlice.sliceTail = currentTail;
                this.globalSlice.apply(this.globalBufferedUpdates, BufferedUpdates.MAX_INT);
            }
            boolean bl = this.globalBufferedUpdates.any();
            return bl;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    public int getBufferedUpdatesTermsSize() {
        this.globalBufferLock.lock();
        try {
            this.forceApplyGlobalSlice();
            int n = this.globalBufferedUpdates.deleteTerms.size();
            return n;
        }
        finally {
            this.globalBufferLock.unlock();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.globalBufferedUpdates.bytesUsed.get();
    }

    public String toString() {
        return "DWDQ: [ generation: " + this.generation + " ]";
    }

    public long getNextSequenceNumber() {
        long seqNo = this.nextSeqNo.getAndIncrement();
        assert (seqNo < this.maxSeqNo) : "seqNo=" + seqNo + " vs maxSeqNo=" + this.maxSeqNo;
        return seqNo;
    }

    public long getLastSequenceNumber() {
        return this.nextSeqNo.get() - 1L;
    }

    public void skipSequenceNumbers(long jump) {
        this.nextSeqNo.addAndGet(jump);
    }

    private static final class DocValuesUpdatesNode
    extends Node<DocValuesUpdate[]> {
        DocValuesUpdatesNode(DocValuesUpdate ... updates) {
            super(updates);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            block4: for (DocValuesUpdate update2 : (DocValuesUpdate[])this.item) {
                switch (update2.type) {
                    case NUMERIC: {
                        bufferedUpdates.addNumericUpdate((DocValuesUpdate.NumericDocValuesUpdate)update2, docIDUpto);
                        continue block4;
                    }
                    case BINARY: {
                        bufferedUpdates.addBinaryUpdate((DocValuesUpdate.BinaryDocValuesUpdate)update2, docIDUpto);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException((Object)((Object)update2.type) + " DocValues updates not supported yet!");
                    }
                }
            }
        }

        @Override
        boolean isDelete() {
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("docValuesUpdates: ");
            if (((DocValuesUpdate[])this.item).length > 0) {
                sb.append("term=").append(((DocValuesUpdate[])this.item)[0].term).append("; updates: [");
                for (DocValuesUpdate update2 : (DocValuesUpdate[])this.item) {
                    sb.append(update2.field).append(':').append(update2.valueToString()).append(',');
                }
                sb.setCharAt(sb.length() - 1, ']');
            }
            return sb.toString();
        }
    }

    private static final class TermArrayNode
    extends Node<Term[]> {
        TermArrayNode(Term[] term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Term term : (Term[])this.item) {
                bufferedUpdates.addTerm(term, docIDUpto);
            }
        }

        public String toString() {
            return "dels=" + Arrays.toString((Object[])this.item);
        }
    }

    private static final class QueryArrayNode
    extends Node<Query[]> {
        QueryArrayNode(Query[] query2) {
            super(query2);
        }

        @Override
        void apply(BufferedUpdates bufferedUpdates, int docIDUpto) {
            for (Query query2 : (Query[])this.item) {
                bufferedUpdates.addQuery(query2, docIDUpto);
            }
        }
    }

    private static final class TermNode
    extends Node<Term> {
        TermNode(Term term) {
            super(term);
        }

        @Override
        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            bufferedDeletes.addTerm((Term)this.item, docIDUpto);
        }

        public String toString() {
            return "del=" + this.item;
        }
    }

    static class Node<T> {
        volatile Node<?> next;
        final T item;

        Node(T item) {
            this.item = item;
        }

        void apply(BufferedUpdates bufferedDeletes, int docIDUpto) {
            throw new IllegalStateException("sentinel item must never be applied");
        }

        boolean isDelete() {
            return true;
        }
    }

    static class DeleteSlice {
        Node<?> sliceHead;
        Node<?> sliceTail;

        DeleteSlice(Node<?> currentTail) {
            assert (currentTail != null);
            this.sliceTail = currentTail;
            this.sliceHead = this.sliceTail;
        }

        void apply(BufferedUpdates del, int docIDUpto) {
            if (this.sliceHead == this.sliceTail) {
                return;
            }
            Node<?> current = this.sliceHead;
            do {
                current = current.next;
                assert (current != null) : "slice property violated between the head on the tail must not be a null node";
                current.apply(del, docIDUpto);
            } while (current != this.sliceTail);
            this.reset();
        }

        void reset() {
            this.sliceHead = this.sliceTail;
        }

        boolean isTail(Node<?> node) {
            return this.sliceTail == node;
        }

        boolean isTailItem(Object object) {
            return this.sliceTail.item == object;
        }

        boolean isEmpty() {
            return this.sliceHead == this.sliceTail;
        }
    }
}

