/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.apache.lucene.analysis.util.AbstractAnalysisFactory;
import org.apache.lucene.util.SPIClassIterator;

public final class AnalysisSPILoader<S extends AbstractAnalysisFactory> {
    private volatile Map<String, Class<? extends S>> services = Collections.emptyMap();
    private final Class<S> clazz;
    private final String[] suffixes;

    public AnalysisSPILoader(Class<S> clazz) {
        this(clazz, new String[]{clazz.getSimpleName()});
    }

    public AnalysisSPILoader(Class<S> clazz, ClassLoader loader) {
        this(clazz, new String[]{clazz.getSimpleName()}, loader);
    }

    public AnalysisSPILoader(Class<S> clazz, String[] suffixes) {
        this(clazz, suffixes, null);
    }

    public AnalysisSPILoader(Class<S> clazz, String[] suffixes, ClassLoader classloader) {
        this.clazz = clazz;
        this.suffixes = suffixes;
        ClassLoader clazzClassloader = clazz.getClassLoader();
        if (classloader == null) {
            classloader = clazzClassloader;
        }
        if (clazzClassloader != null && !SPIClassIterator.isParentClassLoader(clazzClassloader, classloader)) {
            this.reload(clazzClassloader);
        }
        this.reload(classloader);
    }

    public synchronized void reload(ClassLoader classloader) {
        Objects.requireNonNull(classloader, "classloader");
        LinkedHashMap<String, Class<S>> services = new LinkedHashMap<String, Class<S>>(this.services);
        SPIClassIterator<S> loader = SPIClassIterator.get(this.clazz, classloader);
        while (loader.hasNext()) {
            Object service = loader.next();
            String clazzName = ((Class)service).getSimpleName();
            String name = null;
            for (String suffix : this.suffixes) {
                if (!clazzName.endsWith(suffix)) continue;
                name = clazzName.substring(0, clazzName.length() - suffix.length()).toLowerCase(Locale.ROOT);
                break;
            }
            if (name == null) {
                throw new ServiceConfigurationError("The class name " + ((Class)service).getName() + " has wrong suffix, allowed are: " + Arrays.toString(this.suffixes));
            }
            if (services.containsKey(name)) continue;
            services.put(name, (Class<S>)service);
        }
        this.services = Collections.unmodifiableMap(services);
    }

    public S newInstance(String name, Map<String, String> args) {
        Class<S> service = this.lookupClass(name);
        return AnalysisSPILoader.newFactoryClassInstance(service, args);
    }

    public Class<? extends S> lookupClass(String name) {
        Class<? extends S> service = this.services.get(name.toLowerCase(Locale.ROOT));
        if (service != null) {
            return service;
        }
        throw new IllegalArgumentException("A SPI class of type " + this.clazz.getName() + " with name '" + name + "' does not exist. You need to add the corresponding JAR file supporting this SPI to your classpath. The current classpath supports the following names: " + this.availableServices());
    }

    public Set<String> availableServices() {
        return this.services.keySet();
    }

    public static <T extends AbstractAnalysisFactory> T newFactoryClassInstance(Class<T> clazz, Map<String, String> args) {
        try {
            return (T)((AbstractAnalysisFactory)clazz.getConstructor(Map.class).newInstance(args));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unexpected checked exception while calling constructor of " + clazz.getName(), cause);
        }
        catch (ReflectiveOperationException e2) {
            throw new UnsupportedOperationException("Factory " + clazz.getName() + " cannot be instantiated. This is likely due to missing Map<String,String> constructor.", e2);
        }
    }
}

