/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public final class FixedShingleFilter
extends TokenFilter {
    private final Deque<Token> tokenPool = new ArrayDeque<Token>();
    private static final int MAX_SHINGLE_STACK_SIZE = 1000;
    private static final int MAX_SHINGLE_SIZE = 4;
    private final int shingleSize;
    private final String tokenSeparator;
    private final Token gapToken = new Token(new AttributeSource());
    private final Token endToken = new Token(new AttributeSource());
    private final PositionIncrementAttribute incAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private Token[] currentShingleTokens;
    private int currentShingleStackSize;
    private boolean inputStreamExhausted = false;

    public FixedShingleFilter(TokenStream input, int shingleSize) {
        this(input, shingleSize, " ", "_");
    }

    public FixedShingleFilter(TokenStream input, int shingleSize, String tokenSeparator, String fillerToken) {
        super(input);
        if (shingleSize <= 1 || shingleSize > 4) {
            throw new IllegalArgumentException("Shingle size must be between 2 and 4, got " + shingleSize);
        }
        this.shingleSize = shingleSize;
        this.tokenSeparator = tokenSeparator;
        this.gapToken.termAtt.setEmpty().append(fillerToken);
        this.currentShingleTokens = new Token[shingleSize];
    }

    @Override
    public boolean incrementToken() throws IOException {
        int posInc = 0;
        if (!this.nextShingle()) {
            Token nextRoot = this.nextTokenInStream(this.currentShingleTokens[0]);
            if (nextRoot == this.endToken) {
                return false;
            }
            this.recycleToken(this.currentShingleTokens[0]);
            if (!this.resetShingleRoot(nextRoot)) {
                return false;
            }
            posInc = this.currentShingleTokens[0].posInc();
        }
        this.clearAttributes();
        this.incAtt.setPositionIncrement(posInc);
        this.offsetAtt.setOffset(this.currentShingleTokens[0].startOffset(), this.lastTokenInShingle().endOffset());
        this.termAtt.setEmpty();
        this.termAtt.append(this.currentShingleTokens[0].term());
        this.typeAtt.setType("shingle");
        for (int i = 1; i < this.shingleSize; ++i) {
            this.termAtt.append(this.tokenSeparator).append(this.currentShingleTokens[i].term());
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.tokenPool.clear();
        this.currentShingleTokens[0] = null;
        this.inputStreamExhausted = false;
        this.currentShingleStackSize = 0;
    }

    @Override
    public void end() throws IOException {
        if (!this.inputStreamExhausted) {
            this.finishInnerStream();
        }
        this.clearAttributes();
        this.offsetAtt.setOffset(0, this.endToken.endOffset());
    }

    private void finishInnerStream() throws IOException {
        this.input.end();
        this.inputStreamExhausted = true;
        this.endToken.posIncAtt.setPositionIncrement(this.incAtt.getPositionIncrement());
        OffsetAttribute inputOffsets = this.input.getAttribute(OffsetAttribute.class);
        this.endToken.offsetAtt.setOffset(inputOffsets.startOffset(), inputOffsets.endOffset());
    }

    private Token lastTokenInShingle() {
        int lastTokenIndex = this.shingleSize - 1;
        while (this.currentShingleTokens[lastTokenIndex] == this.gapToken) {
            --lastTokenIndex;
        }
        return this.currentShingleTokens[lastTokenIndex];
    }

    private boolean resetShingleRoot(Token token) throws IOException {
        this.currentShingleTokens[0] = token;
        for (int i = 1; i < this.shingleSize; ++i) {
            int j;
            Token current = this.nextTokenInGraph(this.currentShingleTokens[i - 1]);
            if (current == this.endToken) {
                if (this.endToken.posInc() + i >= this.shingleSize) {
                    for (j = i; j < this.shingleSize; ++j) {
                        this.currentShingleTokens[i] = this.gapToken;
                        ++i;
                    }
                    return true;
                }
                return false;
            }
            if (current.posInc() > 1) {
                for (j = 1; j < current.posInc(); ++j) {
                    this.currentShingleTokens[i] = this.gapToken;
                    if (++i < this.shingleSize) continue;
                    return true;
                }
            }
            this.currentShingleTokens[i] = current;
        }
        return true;
    }

    private boolean nextShingle() throws IOException {
        return this.currentShingleTokens[0] != null && this.advanceStack();
    }

    private boolean lastInStack(Token token) throws IOException {
        Token next = this.nextTokenInStream(token);
        return next == this.endToken || next.posInc() != 0;
    }

    private boolean advanceStack() throws IOException {
        for (int i = this.shingleSize - 1; i >= 1; --i) {
            if (this.currentShingleTokens[i] == this.gapToken || this.lastInStack(this.currentShingleTokens[i])) continue;
            this.currentShingleTokens[i] = this.nextTokenInStream(this.currentShingleTokens[i]);
            for (int j = i + 1; j < this.shingleSize; ++j) {
                this.currentShingleTokens[j] = this.nextTokenInGraph(this.currentShingleTokens[j - 1]);
            }
            if (this.currentShingleStackSize++ > 1000) {
                throw new IllegalStateException("Too many shingles (> 1000) at term [" + this.currentShingleTokens[0].term() + "]");
            }
            return true;
        }
        this.currentShingleStackSize = 0;
        return false;
    }

    private Token newToken() {
        Token token = this.tokenPool.size() == 0 ? new Token(this.cloneAttributes()) : this.tokenPool.removeFirst();
        token.reset(this);
        return token;
    }

    private void recycleToken(Token token) {
        if (token == null) {
            return;
        }
        token.nextToken = null;
        this.tokenPool.add(token);
    }

    int instantiatedTokenCount() {
        int tokenCount = this.tokenPool.size() + 1;
        if (this.currentShingleTokens[0] == this.endToken || this.currentShingleTokens[0] == null) {
            return tokenCount;
        }
        Token t = this.currentShingleTokens[0];
        while (t != this.endToken && t != null) {
            ++tokenCount;
            t = t.nextToken;
        }
        return tokenCount;
    }

    private Token nextTokenInGraph(Token token) throws IOException {
        do {
            if ((token = this.nextTokenInStream(token)) != this.endToken) continue;
            return this.endToken;
        } while (token.posInc() == 0);
        return token;
    }

    private Token nextTokenInStream(Token token) throws IOException {
        if (token != null && token.nextToken != null) {
            return token.nextToken;
        }
        if (!this.input.incrementToken()) {
            this.finishInnerStream();
            if (token == null) {
                return this.endToken;
            }
            token.nextToken = this.endToken;
            return this.endToken;
        }
        if (token == null) {
            return this.newToken();
        }
        token.nextToken = this.newToken();
        return token.nextToken;
    }

    private static class Token {
        final AttributeSource attSource;
        final PositionIncrementAttribute posIncAtt;
        final CharTermAttribute termAtt;
        final OffsetAttribute offsetAtt;
        Token nextToken;

        Token(AttributeSource attSource) {
            this.attSource = attSource;
            this.posIncAtt = attSource.addAttribute(PositionIncrementAttribute.class);
            this.termAtt = attSource.addAttribute(CharTermAttribute.class);
            this.offsetAtt = attSource.addAttribute(OffsetAttribute.class);
        }

        int posInc() {
            return this.posIncAtt.getPositionIncrement();
        }

        CharSequence term() {
            return this.termAtt;
        }

        int startOffset() {
            return this.offsetAtt.startOffset();
        }

        int endOffset() {
            return this.offsetAtt.endOffset();
        }

        void reset(AttributeSource attSource) {
            attSource.copyTo(this.attSource);
            this.nextToken = null;
        }

        public String toString() {
            return this.term() + "(" + this.startOffset() + "," + this.endOffset() + ") " + this.posInc();
        }
    }
}

