/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingUtils;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.modify.UpdateProcessRemote;
import org.apache.jena.sparql.modify.UpdateProcessRemoteForm;
import org.apache.jena.sparql.modify.UpdateProcessorBase;
import org.apache.jena.sparql.modify.UpdateProcessorStreamingBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateProcessorStreaming;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionFactory {
    public static UpdateProcessor create(Update update2, Dataset dataset) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), dataset);
    }

    public static UpdateProcessor create(Update update2, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), datasetGraph);
    }

    public static UpdateProcessor create(Update update2, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(update2, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(Update update2, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), datasetGraph, inputBinding);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset) {
        return UpdateExecutionFactory.make(updateRequest, dataset.asDatasetGraph(), null, null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, null);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(updateRequest, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, null);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding));
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, null);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, Context context2) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, context2);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Context context2) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, context2);
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding, Context context2) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding), context2);
    }

    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, context2);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, dataset.asDatasetGraph(), null, context2);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, context2);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding, Context context2) {
        return UpdateExecutionFactory.create(updateRequest, dataset.asDatasetGraph(), BindingUtils.asBinding(inputBinding), context2);
    }

    public static UpdateProcessor create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, context2);
    }

    private static UpdateProcessor make(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        Context cxt = Context.setupContextForDataset(context2, datasetGraph);
        UpdateEngineFactory f = UpdateEngineRegistry.get().find(datasetGraph, cxt);
        if (f == null) {
            return null;
        }
        UpdateProcessorBase uProc = new UpdateProcessorBase(updateRequest, datasetGraph, inputBinding, cxt, f);
        return uProc;
    }

    private static UpdateProcessorStreaming makeStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        Context cxt = Context.setupContextForDataset(context2, datasetGraph);
        UpdateEngineFactory f = UpdateEngineRegistry.get().find(datasetGraph, cxt);
        if (f == null) {
            return null;
        }
        UpdateProcessorStreamingBase uProc = new UpdateProcessorStreamingBase(datasetGraph, inputBinding, cxt, f);
        return uProc;
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, null, null, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, HttpClient client) {
        return UpdateExecutionFactory.createRemote(update2, remoteEndpoint, client, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, null, client, httpContext);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, context2, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context2, HttpClient client) {
        return UpdateExecutionFactory.createRemote(update2, remoteEndpoint, context2, client, null);
    }

    public static UpdateProcessor createRemote(Update update2, String remoteEndpoint, Context context2, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemote(new UpdateRequest(update2), remoteEndpoint, context2, client);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, null, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, HttpClient client) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, client);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, null, client, httpContext);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.createRemote(updateRequest, remoteEndpoint, context2, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2, HttpClient client) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, context2, client, null);
    }

    public static UpdateProcessor createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2, HttpClient client, HttpContext httpContext) {
        return new UpdateProcessRemote(updateRequest, remoteEndpoint, context2, client, httpContext);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null, null, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, HttpClient client) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null, client);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemoteForm(update2, remoteEndpoint, null, client, httpContext);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update2), remoteEndpoint, context2, null);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context2, HttpClient client) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update2), remoteEndpoint, null, client);
    }

    public static UpdateProcessor createRemoteForm(Update update2, String remoteEndpoint, Context context2, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemoteForm(new UpdateRequest(update2), remoteEndpoint, null, client, httpContext);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, null, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, HttpClient client) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, client);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, HttpClient client, HttpContext httpContext) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, null, client, httpContext);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context2);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context2, HttpClient client) {
        return UpdateExecutionFactory.createRemoteForm(updateRequest, remoteEndpoint, context2, client, null);
    }

    public static UpdateProcessor createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context2, HttpClient client, HttpContext httpContext) {
        return new UpdateProcessRemoteForm(updateRequest, remoteEndpoint, context2, client, httpContext);
    }
}

