/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixEntry;
import org.apache.jena.dboe.storage.prefixes.PrefixLib;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;

public class StoragePrefixesTDB
implements StoragePrefixes {
    static final RecordFactory factory = new RecordFactory(24, 0);
    private TransactionalSystem txnSystem;
    private NodeTupleTable prefixTable;

    public StoragePrefixesTDB(TransactionalSystem txnSystem, NodeTupleTable prefixTable) {
        this.txnSystem = txnSystem;
        this.prefixTable = prefixTable;
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.prefixTable;
    }

    @Override
    public String get(Node graphNode, String prefix) {
        this.requireTxn();
        graphNode = PrefixLib.canonicalGraphName(graphNode);
        Node p = NodeFactory.createLiteral(prefix);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(graphNode, p, null);
        if (!iter.hasNext()) {
            return null;
        }
        Node x = iter.next().get(2);
        Iter.close(iter);
        return x.getURI();
    }

    @Override
    public Iterator<PrefixEntry> get(Node graphNode) {
        this.requireTxn();
        graphNode = PrefixLib.canonicalGraphName(graphNode);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(graphNode, null, null);
        return Iter.iter(iter).map(t -> PrefixEntry.create(((Node)t.get(1)).getLiteralLexicalForm(), ((Node)t.get(2)).getURI()));
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        this.requireTxn();
        Iterator<Tuple<Node>> iter = this.prefixTable.find(new Node[]{null, null, null});
        return Iter.iter(iter).map(t -> (Node)t.get(0)).distinct();
    }

    @Override
    public void add(Node graphNode, String prefix, String iriStr) {
        this.ensureWriteTxn();
        this.add_ext(graphNode, prefix, iriStr);
    }

    public void add_ext(Node graphNode, String prefix, String iriStr) {
        graphNode = PrefixLib.canonicalGraphName(graphNode);
        Node p = NodeFactory.createLiteral(prefix);
        Node u = NodeFactory.createURI(iriStr);
        this.remove_ext(graphNode, p, Node.ANY);
        this.prefixTable.addRow(graphNode, p, u);
    }

    @Override
    public void delete(Node graphNode, String prefix) {
        Node p = NodeFactory.createLiteral(prefix);
        this.remove(graphNode, p, null);
    }

    @Override
    public void deleteAll(Node graphNode) {
        this.remove(graphNode, null, null);
    }

    private void remove(Node g, Node p, Node u) {
        this.ensureWriteTxn();
        this.remove_ext(g, p, u);
    }

    private void remove_ext(Node g, Node p, Node u) {
        g = PrefixLib.canonicalGraphName(g);
        Iterator<Tuple<Node>> iter = this.prefixTable.find(g, p, u);
        List<Tuple<Node>> list = Iter.toList(iter);
        for (Tuple<Node> tuple : list) {
            this.prefixTable.deleteRow(tuple.get(0), tuple.get(1), tuple.get(2));
        }
    }

    @Override
    public boolean isEmpty() {
        this.requireTxn();
        return this.prefixTable.isEmpty();
    }

    @Override
    public int size() {
        this.requireTxn();
        return (int)this.prefixTable.size();
    }

    private void requireTxn() {
    }

    private void ensureWriteTxn() {
        Transaction txn = this.txnSystem.getThreadTransaction();
        if (txn == null) {
            throw new TransactionException("Not in a transaction");
        }
        txn.ensureWriteTxn();
    }
}

