/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.loader.base;

import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.atlas.logging.Log;

public class ProgressMonitorContext {
    long ticks;
    Timer timer;
    private int depth = 0;

    public ProgressMonitorContext(long ticks, Timer timer) {
        this.ticks = ticks;
        this.timer = timer;
    }

    public void tick() {
        ++this.ticks;
    }

    public void start() {
        if (this.depth == 0) {
            this.timer.startTimer();
        }
        ++this.depth;
    }

    public void finish() {
        --this.depth;
        if (this.depth < 0) {
            Log.error(this, "Misaligned start/finish");
            return;
        }
        if (this.depth == 0) {
            this.timer.endTimer();
        }
    }

    public long getElapsed() {
        return this.depth < 0 ? -1L : this.timer.readTimer();
    }
}

