/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBase;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.solver.BindingNodeId;
import org.apache.jena.tdb.store.NodeId;
import org.apache.jena.tdb.store.nodetable.NodeTable;

public class BindingTDB
extends BindingBase {
    private final NodeTable nodeTable;
    private final BindingNodeId idBinding;
    private static final boolean caching = false;
    private final Map<Var, Node> cache = null;
    private List<Var> vars = null;

    public BindingTDB(BindingNodeId idBinding, NodeTable nodeTable) {
        super(idBinding.getParentBinding());
        this.idBinding = idBinding;
        this.nodeTable = nodeTable;
    }

    @Override
    protected int size1() {
        return this.idBinding.size();
    }

    @Override
    protected Iterator<Var> vars1() {
        if (this.vars == null) {
            this.vars = this.calcVars();
        }
        return this.vars.iterator();
    }

    private List<Var> calcVars() {
        ArrayList<Var> vars = new ArrayList<Var>(4);
        Binding b = this.idBinding.getParentBinding();
        Iterator iter = this.idBinding.iterator();
        for (Var v : this.idBinding) {
            if (b != null && b.contains(v)) continue;
            vars.add(v);
        }
        return vars;
    }

    @Override
    protected boolean isEmpty1() {
        return this.size1() == 0;
    }

    @Override
    public boolean contains1(Var var) {
        return this.idBinding.containsKey(var);
    }

    public BindingNodeId getBindingId() {
        return this.idBinding;
    }

    public NodeId getNodeId(Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        if (id != null) {
            return id;
        }
        if (NodeId.isDoesNotExist(id)) {
            return null;
        }
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof BindingTDB) {
            return ((BindingTDB)this.parent).getNodeId(var);
        }
        return null;
    }

    @Override
    public Node get1(Var var) {
        try {
            Node n = this.cacheGet(var);
            if (n != null) {
                return n;
            }
            NodeId id = (NodeId)this.idBinding.get(var);
            if (id == null) {
                return null;
            }
            if (NodeId.isDoesNotExist(id)) {
                return null;
            }
            n = this.nodeTable.getNodeForNodeId(id);
            if (n == null) {
                throw new TDBException("No node in NodeTable for NodeId " + id);
            }
            this.cachePut(var, n);
            return n;
        }
        catch (Exception ex) {
            Log.error(this, String.format("get1(%s)", var), (Throwable)ex);
            return null;
        }
    }

    private void cachePut(Var var, Node n) {
        if (this.cache != null) {
            this.cache.put(var, n);
        }
    }

    private Node cacheGet(Var var) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(var);
    }

    @Override
    protected void format(StringBuffer sbuff, Var var) {
        NodeId id = (NodeId)this.idBinding.get(var);
        String extra = "";
        if (id != null) {
            extra = "/" + id;
        }
        Node node = this.get(var);
        String tmp = NodeFmtLib.displayStr(node);
        sbuff.append("( ?" + var.getVarName() + extra + " = " + tmp + " )");
    }
}

