/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.NodeIsomorphismMap;
import org.apache.jena.sparql.util.NodeUtils;

public class ElementData
extends Element {
    private List<Var> vars = new ArrayList<Var>();
    private List<Binding> rows = new ArrayList<Binding>();

    public Table getTable() {
        return new TableData(this.vars, this.rows);
    }

    public List<Var> getVars() {
        return this.vars;
    }

    public List<Binding> getRows() {
        return this.rows;
    }

    public void add(Var var) {
        if (!this.vars.contains(var)) {
            this.vars.add(var);
        }
    }

    public void add(Binding binding) {
        Iterator<Var> iter = binding.vars();
        while (iter.hasNext()) {
            Var v = iter.next();
            if (this.vars.contains(v)) continue;
            throw new ARQException("Variable " + v + " not already declared for ElementData");
        }
        this.rows.add(binding);
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementData)) {
            return false;
        }
        ElementData f2 = (ElementData)el2;
        if (!this.vars.equals(f2.vars)) {
            return false;
        }
        return ResultSetCompare.equalsByTest(this.rows, f2.rows, new ResultSetCompare.BNodeIso(NodeUtils.sameNode));
    }

    @Override
    public int hashCode() {
        return this.vars.hashCode() ^ this.rows.hashCode();
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

