/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.NodeShape;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.path.Path;

public class ValidationProc {
    private static IndentedWriter out = IndentedWriter.stdout;

    public static ValidationReport simpleValidation(Graph shapesGraph, Graph data) {
        return ValidationProc.simpleValidation(shapesGraph, data, false);
    }

    public static ValidationReport simpleValidation(Graph shapesGraph, Graph data, boolean verbose) {
        Shapes shapes = Shapes.parse(shapesGraph);
        return ValidationProc.simpleValidation(shapes, data, verbose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport simpleValidation(Shapes shapes, Graph data, boolean verbose) {
        int x = out.getAbsoluteIndent();
        try {
            ValidationContext vCxt = new ValidationContext(shapes, data);
            vCxt.setVerbose(verbose);
            ValidationReport validationReport = ValidationProc.simpleValidation(vCxt, shapes, data);
            return validationReport;
        }
        finally {
            out.setAbsoluteIndent(x);
        }
    }

    public static ValidationReport simpleValidation(ValidationContext vCxt, Iterable<Shape> shapes, Graph data) {
        for (Shape shape : shapes) {
            ValidationProc.simpleValidation(vCxt, data, shape);
        }
        if (vCxt.isVerbose()) {
            out.ensureStartOfLine();
        }
        return vCxt.generateReport();
    }

    public static void simpleValidation(ValidationContext vCxt, Graph data, Shape shape) {
        ValidationProc.simpleValidationInternal(vCxt, data, null, shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationReport simpleValidationNode(Shapes shapes, Graph data, Node node, boolean verbose) {
        int x = out.getAbsoluteIndent();
        try {
            ValidationContext vCxt = new ValidationContext(shapes, data);
            vCxt.setVerbose(verbose);
            ValidationReport validationReport = ValidationProc.simpleValidationNode(vCxt, shapes, node, data);
            return validationReport;
        }
        finally {
            out.setAbsoluteIndent(x);
        }
    }

    private static ValidationReport simpleValidationNode(ValidationContext vCxt, Shapes shapes, Node node, Graph data) {
        for (Shape shape : shapes) {
            ValidationProc.simpleValidationNode(vCxt, data, node, shape);
        }
        if (vCxt.isVerbose()) {
            out.ensureStartOfLine();
        }
        return vCxt.generateReport();
    }

    private static void simpleValidationNode(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        ValidationProc.simpleValidationInternal(vCxt, data, node, shape);
    }

    private static void simpleValidationInternal(ValidationContext vCxt, Graph data, Node node, Shape shape) {
        Collection<Node> focusNodes;
        if (node != null) {
            if (!ValidationProc.isFocusNode(shape, node, data)) {
                return;
            }
            focusNodes = Collections.singleton(node);
        } else {
            focusNodes = ValidationProc.getFocusNodes(data, shape);
        }
        if (vCxt.isVerbose()) {
            out.println(shape.toString());
            out.printf("N: FocusNodes(%d): %s\n", focusNodes.size(), focusNodes);
            out.incIndent();
        }
        for (Node focusNode : focusNodes) {
            if (vCxt.isVerbose()) {
                out.println("F: " + focusNode);
            }
            ValidationProc.validateShape(vCxt, data, shape, focusNode);
        }
        if (vCxt.isVerbose()) {
            out.decIndent();
        }
    }

    public static void execValidateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        ValidationProc.validateShape(vCxt, data, shape, focusNode);
    }

    private static void validateShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        Set<Node> vNodes;
        Path path;
        if (shape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("S: " + shape);
        }
        if (shape instanceof NodeShape) {
            path = null;
            vNodes = null;
        } else if (shape instanceof PropertyShape) {
            PropertyShape propertyShape = (PropertyShape)shape;
            path = propertyShape.getPath();
            vNodes = ShaclPaths.valueNodes(data, focusNode, propertyShape.getPath());
        } else {
            if (vCxt.isVerbose()) {
                out.println("Z: " + shape);
            }
            return;
        }
        for (Constraint c : shape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + c);
            }
            ValidationProc.evalConstraint(vCxt, data, shape, focusNode, path, vNodes, c);
        }
        ValidationProc.validationPropertyShapes(vCxt, data, shape.getPropertyShapes(), focusNode);
        if (vCxt.isVerbose()) {
            out.println();
        }
    }

    private static void validationPropertyShapes(ValidationContext vCxt, Graph data, List<PropertyShape> propertyShapes, Node focusNode) {
        if (propertyShapes == null) {
            return;
        }
        for (PropertyShape propertyShape : propertyShapes) {
            ValidationProc.validationPropertyShape(vCxt, data, propertyShape, focusNode);
        }
    }

    private static void validationPropertyShape(ValidationContext vCxt, Graph data, PropertyShape propertyShape, Node focusNode) {
        if (propertyShape.deactivated()) {
            return;
        }
        if (vCxt.isVerbose()) {
            out.println("P: " + propertyShape);
        }
        Set<Node> vNodes = ShaclPaths.valueNodes(data, focusNode, propertyShape.getPath());
        for (Constraint c : propertyShape.getConstraints()) {
            if (vCxt.isVerbose()) {
                out.println("C: " + focusNode + " :: " + c);
            }
            ValidationProc.evalConstraint(vCxt, data, propertyShape, focusNode, propertyShape.getPath(), vNodes, c);
        }
        vNodes.forEach(vNode -> ValidationProc.validationPropertyShapes(vCxt, data, propertyShape.getPropertyShapes(), vNode));
    }

    private static void evalConstraint(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Constraint c) {
        if (path == null) {
            if (pathNodes != null) {
                throw new InternalErrorException("Path is null but pathNodes is not null");
            }
            c.validateNodeShape(vCxt, data, shape, focusNode);
            return;
        }
        if (pathNodes == null) {
            throw new InternalErrorException("Path is not null but pathNodes is null");
        }
        c.validatePropertyShape(vCxt, data, shape, focusNode, path, pathNodes);
    }

    private static Collection<Node> getFocusNodes(Graph data, Shape shape) {
        HashSet<Node> acc = new HashSet<Node>();
        shape.getTargets().forEach(target -> acc.addAll(ValidationProc.getFocusNodes(data, target)));
        return acc;
    }

    private static Collection<Node> getFocusNodes(Graph data, Target target) {
        Node targetObj = target.getObject();
        switch (target.getTargetType()) {
            case targetClass: 
            case implicitClass: {
                return G.listAllNodesOfType(data, targetObj);
            }
            case targetNode: {
                return Collections.singletonList(targetObj);
            }
            case targetObjectsOf: {
                return G.setSP(data, null, targetObj);
            }
            case targetSubjectsOf: {
                return G.setPO(data, targetObj, null);
            }
        }
        return Collections.emptyList();
    }

    private static boolean isFocusNode(Shape shape, Node node, Graph data) {
        return shape.getTargets().stream().anyMatch(target -> ValidationProc.isFocusNode(target, node, data));
    }

    private static boolean isFocusNode(Target target, Node node, Graph data) {
        Node targetObject = target.getObject();
        switch (target.getTargetType()) {
            case targetClass: 
            case implicitClass: {
                return G.isOfType(data, node, targetObject);
            }
            case targetNode: {
                return targetObject.equals(node);
            }
            case targetObjectsOf: {
                return data.contains(null, targetObject, node);
            }
            case targetSubjectsOf: {
                return data.contains(node, targetObject, null);
            }
        }
        return false;
    }
}

