/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class UniqueLangConstraint
implements Constraint {
    private final boolean flag;

    public UniqueLangConstraint(boolean flag) {
        this.flag = flag;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        throw new ShaclException("sh:uniqueLang with no path");
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes) {
        if (!this.flag) {
            return;
        }
        HashSet<String> results = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (Node obj : pathNodes) {
            if (!Util.isLangString(obj)) continue;
            String tag = obj.getLiteralLanguage().toLowerCase();
            if (seen.contains(tag) && !results.contains(tag)) {
                String msg = this.toString() + " Duplicate langtag: " + obj.getLiteralLanguage();
                vCxt.reportEntry(msg, shape, focusNode, path, null, this);
                results.add(tag);
            }
            seen.add(tag);
        }
    }

    @Override
    public Node getComponent() {
        return SHACL.UniqueLangConstraintComponent;
    }

    public String toString() {
        return "UniqueLang[" + this.flag + "]";
    }

    public int hashCode() {
        return 17 * Objects.hash(this.flag);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniqueLangConstraint)) {
            return false;
        }
        UniqueLangConstraint other = (UniqueLangConstraint)obj;
        return Objects.equals(this.flag, other.flag);
    }
}

