/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.shacl.engine.Parameter;
import org.apache.jena.shacl.engine.ShaclPaths;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.SparqlConstraint;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.ModelUtils;

class SparqlValidation {
    private static final boolean USE_QueryTransformOps = false;
    private static Pattern pattern = Pattern.compile("(\\{[\\$\\?][^{}]+\\})");

    SparqlValidation() {
    }

    public static void validate(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Node valueNode, Query query2, Multimap<Parameter, Node> parameterMap, Constraint reportConstraint) {
        if (parameterMap != null && parameterMap.keySet().size() == 1 && parameterMap.size() > 1) {
            for (Map.Entry<Parameter, Node> e2 : parameterMap.entries()) {
                Map<Parameter, Node> pmap = Collections.singletonMap(e2.getKey(), e2.getValue());
                boolean b = SparqlValidation.validateMap(vCxt, data, shape, focusNode, path, valueNode, query2, pmap, reportConstraint);
                if (b) continue;
                return;
            }
            return;
        }
        Map<Parameter, Node> pmap = SparqlValidation.flatten(parameterMap);
        SparqlValidation.validateMap(vCxt, data, shape, focusNode, path, valueNode, query2, pmap, reportConstraint);
    }

    private static Map<Parameter, Node> flatten(Multimap<Parameter, Node> parameterMap) {
        if (parameterMap == null) {
            return null;
        }
        HashMap<Parameter, Node> pmap = new HashMap<Parameter, Node>(parameterMap.size());
        parameterMap.forEach((p, v) -> pmap.put((Parameter)p, (Node)v));
        return pmap;
    }

    private static boolean validateMap(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Node valueNode, Query _query, Map<Parameter, Node> parameterMap, Constraint reportConstraint) {
        QueryExecution qExec;
        Model model = ModelFactory.createModelForGraph(data);
        Query query2 = _query;
        if (path != null && !(path instanceof P_Link)) {
            query2 = QueryTransformOps.transform(query2, new ElementTransformPath(SparqlConstraint.varPath, path));
        }
        QuerySolutionMap qsm = SparqlValidation.parameterMapToPreBinding(parameterMap, focusNode, path, model);
        if (query2.isAskType()) {
            qsm.add("value", ModelUtils.convertGraphNodeToRDFNode(valueNode, model));
        }
        if ((qExec = QueryExecutionFactory.create(query2, model, (QuerySolution)qsm)).getQuery().isAskType()) {
            boolean b = qExec.execAsk();
            if (!b) {
                String msg = "SPARQL ASK constraint for " + ShLib.displayStr(valueNode) + " returns false";
                vCxt.reportEntry(msg, shape, focusNode, path, valueNode, reportConstraint);
            }
            return b;
        }
        ResultSet rs = qExec.execSelect();
        if (!rs.hasNext()) {
            return true;
        }
        while (rs.hasNext()) {
            Node qPath;
            Binding row = rs.nextBinding();
            Node value = row.get(SparqlConstraint.varValue);
            if (value == null) {
                value = valueNode;
            }
            String msg = value != null ? "SPARQL SELECT constraint for " + ShLib.displayStr(valueNode) + " returns " + ShLib.displayStr(value) : "SPARQL SELECT constraint for " + ShLib.displayStr(valueNode) + " returns row " + row;
            Path rPath = path;
            if (rPath == null && (qPath = row.get(SparqlConstraint.varPath)) != null) {
                rPath = PathFactory.pathLink(qPath);
            }
            vCxt.reportEntry(msg, shape, focusNode, rPath, value, reportConstraint);
        }
        return false;
    }

    private static Map<Var, Node> parameterMapToSyntaxSubstitutions(Map<Parameter, Node> parameterMap, Node thisNode, Path path) {
        Map<Var, Node> substitions = SparqlValidation.parametersToMap(parameterMap, thisNode);
        if (path != null) {
            SparqlValidation.addSubstition(substitions, "PATH", ShaclPaths.pathNode(path));
        }
        return substitions;
    }

    private static Map<Var, Node> parametersToMap(Map<Parameter, Node> parameterMap, Node thisNode) {
        HashMap<Var, Node> substitions = new HashMap<Var, Node>();
        if (parameterMap != null) {
            parameterMap.forEach((p, n) -> SparqlValidation.addSubstition(substitions, p.getSparqlName(), n));
        }
        SparqlValidation.addSubstition(substitions, "this", thisNode);
        return substitions;
    }

    private static QuerySolutionMap parameterMapToPreBinding(Map<Parameter, Node> parameterMap, Node thisNode, Path path, Model model) {
        QuerySolutionMap qsm = new QuerySolutionMap();
        if (parameterMap != null) {
            parameterMap.forEach((p, n) -> qsm.add(p.getSparqlName(), ModelUtils.convertGraphNodeToRDFNode(n, model)));
        }
        qsm.add("this", ModelUtils.convertGraphNodeToRDFNode(thisNode, model));
        if (path != null) {
            RDFNode z = ModelUtils.convertGraphNodeToRDFNode(ShaclPaths.pathNode(path), model);
            qsm.add("PATH", z);
        }
        return qsm;
    }

    private static void addSubstition(Map<Var, Node> substitions, String sparqlName, Node n) {
        substitions.put(Var.alloc(sparqlName), n);
    }

    private static String messageTemplate(String message, Map<Parameter, Node> parameterMap, Node thisNode, Path path) {
        Map<Var, Node> substitions = SparqlValidation.parametersToMap(parameterMap, thisNode);
        Pattern pattern = Pattern.compile("{[$?][^{}]+}");
        if (path != null) {
            substitions.put(Var.alloc("PATH"), NodeFactory.createLiteral(ShaclPaths.pathToString(path)));
        }
        return SparqlValidation.subsitute(message, substitions);
    }

    private static String subsitute(String string, Map<Var, Node> substitions) {
        StringBuilder sb = new StringBuilder();
        Matcher m = pattern.matcher(string);
        int prev = 0;
        while (m.find()) {
            int i1 = m.start();
            int i2 = m.end();
            String var = m.group();
            String varName = var.substring(2, i2 - i1 - 1);
            sb.append(string.substring(prev, i1));
            Var v = Var.alloc(varName);
            Node n = substitions.get(v);
            if (n == null) {
                sb.append(var);
            } else {
                String z = NodeFmtLib.displayStr(n);
                sb.append(z);
            }
            prev = i2;
        }
        sb.append(string.substring(prev));
        return sb.toString();
    }

    private static class ElementTransformPath
    extends ElementTransformCopyBase {
        private final Var var;
        private final Path path;

        ElementTransformPath(Var varPath, Path path) {
            this.var = varPath;
            this.path = path;
        }

        @Override
        public Element transform(ElementPathBlock el) {
            ElementPathBlock el2 = new ElementPathBlock();
            boolean changed = false;
            PathBlock pathBlock = el.getPattern();
            List<TriplePath> x = pathBlock.getList();
            for (TriplePath tp : x) {
                if (!tp.isTriple()) {
                    el2.addTriple(tp);
                    continue;
                }
                Triple t = tp.asTriple();
                if (!this.var.equals(t.getPredicate())) {
                    el2.addTriple(tp);
                    continue;
                }
                TriplePath tp2 = new TriplePath(t.getSubject(), this.path, t.getObject());
                el2.addTriple(tp2);
                changed = true;
            }
            return changed ? el2 : el;
        }
    }
}

