/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.vocabulary.XSD;

public class DatatypeConstraint
extends ConstraintTerm {
    private final Node datatype;
    private final String dtURI;
    private final RDFDatatype rdfDatatype;

    public DatatypeConstraint(Node dt) {
        this(dt.isURI() ? dt.getURI() : null, Objects.requireNonNull(dt));
        if (!dt.isURI()) {
            throw new IllegalArgumentException("Not a URI: " + dt);
        }
    }

    public DatatypeConstraint(String dt) {
        this(Objects.requireNonNull(dt), NodeFactory.createURI(dt));
    }

    private DatatypeConstraint(String dtURI, Node dt) {
        this.datatype = dt;
        this.dtURI = dtURI;
        this.rdfDatatype = NodeFactory.getType(dtURI);
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (n.isLiteral() && this.dtURI.equals(n.getLiteralDatatypeURI())) {
            if (!this.rdfDatatype.isValid(n.getLiteralLexicalForm())) {
                String errMsg = this.toString() + " : Not valid value : Node " + ShLib.displayStr(n);
                return new ReportItem(errMsg, n);
            }
            return null;
        }
        if (!n.isLiteral()) {
            return new ReportItem(this.toString() + " : Not a literal", n);
        }
        String errMsg = this.toString() + " : Got datatype " + n.getLiteralDatatype().getURI() + " : Node " + ShLib.displayStr(n);
        return new ReportItem(errMsg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.DatatypeConstraintComponent;
    }

    public String toString() {
        String x = this.datatype.isURI() ? (this.dtURI.startsWith(XSD.getURI()) ? "xsd:" + this.datatype.getLocalName() : "<" + this.dtURI + ">") : (this.datatype.isBlank() ? "<_:" + this.datatype.getBlankNodeLabel() + ">" : ShLib.displayStr(this.datatype));
        return "DatatypeConstraint[" + x + "]";
    }

    public int hashCode() {
        return Objects.hash(this.datatype, this.dtURI);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatatypeConstraint)) {
            return false;
        }
        DatatypeConstraint other = (DatatypeConstraint)obj;
        return Objects.equals(this.datatype, other.datatype) && Objects.equals(this.dtURI, other.dtURI);
    }
}

