/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.LangBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LangNTuple<X>
extends LangBase
implements Iterator<X> {
    private static Logger log = LoggerFactory.getLogger(LangNTuple.class);
    protected boolean skipOnBadTerm = false;

    protected LangNTuple(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public final boolean hasNext() {
        return super.moreTokens();
    }

    @Override
    public final X next() {
        return this.parseOne();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract X parseOne();

    protected void skipOne(X object, String printForm, long line, long col) {
        this.errorHandler.warning("Skip: " + printForm, line, col);
    }

    protected abstract Node tokenAsNode(Token var1);

    protected final void checkIRIOrBNode(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        if (token.hasType(TokenType.BNODE)) {
            return;
        }
        this.exception(token, "Expected BNode or IRI: Got: %s", token);
    }

    protected final void checkIRI(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        this.exception(token, "Expected IRI: Got: %s", token);
    }

    protected final void checkRDFTerm(Token token) {
        switch (token.getType()) {
            case IRI: 
            case BNODE: {
                return;
            }
            case STRING: {
                this.checkString(token);
                return;
            }
            case LITERAL_LANG: 
            case LITERAL_DT: {
                this.checkString(token.getSubToken1());
                return;
            }
        }
        this.exception(token, "Illegal object: %s", token);
    }

    private void checkString(Token token) {
        if (token.isLongString()) {
            this.exception(token, "Triple quoted string not permitted: %s", token);
        }
        if (this.isStrictMode && !token.hasStringType(StringType.STRING2)) {
            this.exception(token, "Not a \"\"-quoted string: %s", token);
        }
    }

    public boolean getSkipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public void setSkipOnBadTerm(boolean skipOnBadTerm) {
        this.skipOnBadTerm = skipOnBadTerm;
    }
}

