/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class CollectorStreamRDF
implements StreamRDF {
    private PrefixMap prefixes = PrefixMapFactory.createForInput();
    private String baseIri;
    private List<Triple> triples = new ArrayList<Triple>();
    private List<Quad> quads = new ArrayList<Quad>();

    @Override
    public void start() {
        this.triples.clear();
        this.quads.clear();
        this.prefixes = PrefixMapFactory.createForInput();
    }

    @Override
    public void finish() {
    }

    @Override
    public void triple(Triple triple) {
        this.triples.add(triple);
    }

    @Override
    public void quad(Quad quad) {
        this.quads.add(quad);
    }

    @Override
    public void base(String base) {
        this.baseIri = base;
    }

    @Override
    public void prefix(String prefix, String iri2) {
        this.prefixes.add(prefix, iri2);
    }

    public PrefixMap getPrefixes() {
        return this.prefixes;
    }

    public String getBaseIri() {
        return this.baseIri;
    }

    public List<Triple> getTriples() {
        return this.triples;
    }

    public List<Quad> getQuads() {
        return this.quads;
    }
}

