/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import org.apache.jena.query.text.TextQueryPF;
import org.apache.jena.query.text.assembler.TextAssembler;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.mgt.SystemInfo;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.util.Metadata;

public class TextQuery {
    private static volatile boolean initialized = false;
    private static Object lock = new Object();
    public static String NS = "http://jena.apache.org/text#";
    public static String IRI = "http://jena.apache.org/#text";
    public static final Symbol textIndex = Symbol.create(NS + "index");
    public static final String PATH = "org.apache.jena.query.text";
    private static String metadataLocation = "org/apache/jena/query/text/properties.xml";
    private static Metadata metadata = new Metadata(metadataLocation);
    public static final String NAME = "ARQ Text Query";
    public static final String VERSION = metadata.get("org.apache.jena.query.text.version", "unknown");
    public static final String BUILD_DATE = metadata.get("org.apache.jena.query.text.build.datetime", "unset");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (initialized) {
                JenaSystem.logLifecycle("TextQuery.init - skip", new Object[0]);
                return;
            }
            initialized = true;
            JenaSystem.logLifecycle("TextQuery.init - start", new Object[0]);
            TextAssembler.init();
            SystemInfo sysInfo = new SystemInfo(IRI, PATH, VERSION, BUILD_DATE);
            SystemARQ.registerSubSystem(sysInfo);
            PropertyFunctionRegistry.get().put("http://jena.apache.org/text#query", new PropertyFunctionFactory(){

                @Override
                public PropertyFunction create(String uri) {
                    return new TextQueryPF();
                }
            });
            JenaSystem.logLifecycle("TextQuery.init - finish", new Object[0]);
        }
    }

    static {
        JenaSystem.init();
    }
}

