/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.html;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.validation.html.ValidatorHtmlLib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWriter;

public class DataValidatorHTML {
    static final String paramLineNumbers = "linenumbers";
    static final String paramFormat = "outputFormat";
    static final String paramIndirection = "url";
    static final String paramData = "data";
    static final String paramSyntax = "languageSyntax";
    static final long LIMIT = 50000L;

    private DataValidatorHTML() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeHTML(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        try {
            Lang language;
            String syntax = FusekiNetLib.safeParameter(httpRequest, paramSyntax);
            if (syntax == null || syntax.equals("")) {
                syntax = RDFLanguages.NQUADS.getName();
            }
            if ((language = RDFLanguages.shortnameToLang(syntax)) == null) {
                httpResponse.sendError(400, "Unknown syntax: " + syntax);
                return;
            }
            Reader input = DataValidatorHTML.createInput(httpRequest, httpResponse);
            ServletOutputStream outStream = httpResponse.getOutputStream();
            ErrorHandlerMsg errorHandler = new ErrorHandlerMsg(outStream);
            PrintStream stderr = System.err;
            System.setErr(new PrintStream(outStream));
            ValidatorHtmlLib.setHeaders(httpResponse);
            outStream.println("<html>");
            ValidatorHtmlLib.printHead(outStream, "Jena Data Validator Report");
            outStream.println("<body>");
            outStream.println("<h1>RIOT Parser Report</h1>");
            outStream.println("<p>Line and column numbers refer to the original input.</p>");
            outStream.println("<p>&nbsp;</p>");
            OutputStreamNoHTML output1 = new OutputStreamNoHTML(new BufferedOutputStream(outStream));
            StreamRDF output = StreamRDFWriter.getWriterStream((OutputStream)output1, Lang.NQUADS);
            try {
                ValidatorHtmlLib.startFixed(outStream);
                RDFParser parser = RDFParser.create().source(input).strict(true).lang(language).errorHandler(errorHandler).resolveURIs(false).build();
                RiotException exception = null;
                try {
                    output.start();
                    parser.parse(output);
                    output.finish();
                    ((OutputStream)output1).flush();
                    outStream.flush();
                    System.err.flush();
                }
                catch (RiotException ex) {
                    exception = ex;
                }
            }
            finally {
                ValidatorHtmlLib.finishFixed(outStream);
                System.err.flush();
                System.setErr(stderr);
            }
            outStream.println("</body>");
            outStream.println("</html>");
        }
        catch (Exception ex) {
            ValidatorHtmlLib.serviceLog.warn("Exception in validationRequest", ex);
        }
    }

    private static Reader createInput(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        Reader reader = null;
        String[] args = httpRequest.getParameterValues(paramData);
        if (args == null || args.length == 0) {
            System.err.println("Not a form");
            reader = httpRequest.getReader();
        } else {
            if (args.length > 1) {
                httpResponse.sendError(400, "Too many parameters for 'data='");
                return null;
            }
            reader = new StringReader(args[0]);
        }
        if (reader == null) {
            httpResponse.sendError(400, "Can't find data to validate");
            return null;
        }
        return reader;
    }

    private static class ErrorHandlerMsg
    implements ErrorHandler {
        private ServletOutputStream out;

        ErrorHandlerMsg(ServletOutputStream out) {
            this.out = out;
        }

        @Override
        public void warning(String message, long line, long col) {
            this.output(message, line, col, "Warning", "warning");
        }

        @Override
        public void error(String message, long line, long col) {
            this.output(message, line, col, "Error", "error");
        }

        @Override
        public void fatal(String message, long line, long col) {
            this.output(message, line, col, "Fatal", "error");
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        private void output(String message, long line, long col, String typeName, String className) {
            try {
                String str2 = SysRIOT.fmtMessage(message, line, col);
                str2 = ValidatorHtmlLib.htmlQuote(str2);
                this.out.print("<div class=\"" + className + "\">");
                this.out.print(str2);
                this.out.print("</div>");
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }
    }

    static class OutputStreamNoHTML
    extends FilterOutputStream {
        static byte[] escLT = new byte[]{38, 108, 116, 59};
        static byte[] escGT = new byte[]{38, 103, 116, 59};
        static byte[] escAmp = new byte[]{38, 97, 109, 112, 59};

        public OutputStreamNoHTML(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 38) {
                this.writeEsc(escAmp);
            } else if (b == 62) {
                this.writeEsc(escGT);
            } else if (b == 60) {
                this.writeEsc(escLT);
            } else {
                super.write(b);
            }
        }

        private void writeEsc(byte[] bytes) throws IOException {
            for (byte b : bytes) {
                super.write(b);
            }
        }
    }
}

