/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.List;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.SPARQLQueryProcessor;
import org.apache.jena.fuseki.servlets.ServletAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.GraphLoadUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphZero;

public class SPARQL_QueryGeneral
extends ServletAction {
    public SPARQL_QueryGeneral() {
        super(new SPARQL_QueryProc(), Fuseki.actionLog);
    }

    public static class SPARQL_QueryProc
    extends SPARQLQueryProcessor {
        static final int MaxTriples = 100000;
        private static DataService dSrv = SPARQL_QueryProc.emptyDataService();
        private static DataAccessPoint dap = new DataAccessPoint("SPARQL General", dSrv);

        static DataService emptyDataService() {
            DataService dSrv = new DataService(new DatasetGraphZero());
            dSrv.goActive();
            return dSrv;
        }

        @Override
        public void executeLifecycle(HttpAction action) {
            action.setRequest(dap, dSrv);
            super.executeLifecycle(action);
        }

        @Override
        protected void validateRequest(HttpAction action) {
        }

        @Override
        protected void validateQuery(HttpAction action, Query query2) {
        }

        @Override
        protected Pair<DatasetGraph, Query> decideDataset(HttpAction action, Query query2, String queryStringLog) {
            return SPARQL_QueryProc.decideDatasetProtocol(action, query2, queryStringLog);
        }

        private static Pair<DatasetGraph, Query> decideDatasetProtocol(HttpAction action, Query query2, String queryStringLog) {
            DatasetDescription datasetDesc = SPARQLProtocol.getDatasetDescription(action, query2);
            if (datasetDesc == null) {
                return Pair.create(new DatasetGraphZero(), query2);
            }
            if (query2.hasDatasetDescription()) {
                query2 = query2.cloneQuery();
                query2.getNamedGraphURIs().clear();
                query2.getGraphURIs().clear();
            }
            return Pair.create(SPARQL_QueryProc.datasetFromDescriptionWeb(action, datasetDesc), query2);
        }

        private static DatasetGraph datasetFromDescriptionWeb(HttpAction action, DatasetDescription datasetDesc) {
            try {
                if (datasetDesc == null) {
                    return null;
                }
                if (datasetDesc.isEmpty()) {
                    return null;
                }
                List<String> graphURLs = datasetDesc.getDefaultGraphURIs();
                List<String> namedGraphs = datasetDesc.getNamedGraphURIs();
                if (graphURLs.size() == 0 && namedGraphs.size() == 0) {
                    return null;
                }
                Dataset dataset = DatasetFactory.create();
                Model model = ModelFactory.createDefaultModel();
                for (String uri : graphURLs) {
                    if (uri == null || uri.equals("")) {
                        throw new InternalErrorException("Default graph URI is null or the empty string");
                    }
                    try {
                        GraphLoadUtils.loadModel(model, uri, 100000);
                        action.log.info(String.format("[%d] Load (default graph) %s", action.id, uri));
                    }
                    catch (RiotException ex) {
                        action.log.info(String.format("[%d] Parsing error loading %s: %s", action.id, uri, ex.getMessage()));
                        ServletOps.errorBadRequest("Failed to load URL (parse error) " + uri + " : " + ex.getMessage());
                    }
                    catch (Exception ex) {
                        action.log.info(String.format("[%d] Failed to load (default) %s: %s", action.id, uri, ex.getMessage()));
                        ServletOps.errorBadRequest("Failed to load URL " + uri);
                    }
                }
                dataset.setDefaultModel(model);
                if (namedGraphs != null) {
                    for (String uri : namedGraphs) {
                        if (uri == null || uri.equals("")) {
                            throw new InternalErrorException("Named graph URI is null or the empty string");
                        }
                        try {
                            Model model2 = ModelFactory.createDefaultModel();
                            GraphLoadUtils.loadModel(model2, uri, 100000);
                            action.log.info(String.format("[%d] Load (named graph) %s", action.id, uri));
                            dataset.addNamedModel(uri, model2);
                        }
                        catch (RiotException ex) {
                            action.log.info(String.format("[%d] Parsing error loading %s: %s", action.id, uri, ex.getMessage()));
                            ServletOps.errorBadRequest("Failed to load URL (parse error) " + uri + " : " + ex.getMessage());
                        }
                        catch (Exception ex) {
                            action.log.info(String.format("[%d] Failed to load (named graph) %s: %s", action.id, uri, ex.getMessage()));
                            ServletOps.errorBadRequest("Failed to load URL " + uri);
                        }
                    }
                }
                return dataset.asDatasetGraph();
            }
            catch (ActionErrorException ex) {
                throw ex;
            }
            catch (Exception ex) {
                action.log.info(String.format("[%d] SPARQL parameter error: " + ex.getMessage(), action.id, ex));
                ServletOps.errorBadRequest("Parameter error: " + ex.getMessage());
                return null;
            }
        }
    }
}

