/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.BaseActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shacl.ShaclValidator;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.sparql.core.DatasetGraph;

public class SHACL_Validation
extends BaseActionREST {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpAction action) {
        MediaType mediaType = ActionLib.contentNegotation(action, DEF.rdfOffer, DEF.acceptTurtle);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentType());
        if (lang == null) {
            lang = RDFLanguages.TTL;
        }
        action.beginRead();
        try {
            Graph data = SHACL_Validation.determineTarget(action.getActiveDSG(), action);
            Graph shapesGraph = ActionLib.readFromRequest(action, Lang.TTL);
            Shapes shapes = Shapes.parse(shapesGraph);
            ValidationReport report = ShaclValidator.get().validate(shapesGraph, data);
            if (report.conforms()) {
                action.log.info(String.format("[%d] shacl: conforms", action.id));
            } else {
                action.log.info(String.format("[%d] shacl: %d validation errors", action.id, report.getEntries().size()));
            }
            report.getEntries().size();
            action.response.setStatus(200);
            MediaType mt = ActionLib.contentNegotationRDF(action);
            ActionLib.graphResponse(action, report.getGraph(), lang);
        }
        finally {
            action.endRead();
        }
    }

    protected static final Graph determineTarget(DatasetGraph dsg, HttpAction action) {
        boolean dftGraph = ActionLib.getOneHeader(action.request, "default") != null;
        String graphName = ActionLib.getOneHeader(action.request, "graph");
        if (dftGraph && graphName != null) {
            ServletOps.errorBadRequest("Both default graph and named graph specified");
        }
        if (dftGraph) {
            graphName = "default";
        }
        if (graphName == null) {
            graphName = "default";
        }
        if (graphName.equals("default")) {
            return dsg.getDefaultGraph();
        }
        if (graphName.equals("union")) {
            return dsg.getUnionGraph();
        }
        Node gn = NodeFactory.createURI(graphName);
        return dsg.getGraph(gn);
    }
}

