/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.GSPLib;
import org.apache.jena.fuseki.servlets.GSPTarget;
import org.apache.jena.fuseki.servlets.GSP_R;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.fuseki.system.Upload;
import org.apache.jena.fuseki.system.UploadDetails;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.graph.GraphFactory;

public class GSP_RW
extends GSP_R {
    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action.response);
        if (GSP_RW.hasGSPParams(action)) {
            action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,DELETE,POST");
        } else {
            action.response.setHeader("Allow", "GET,HEAD,OPTIONS,PUT,POST");
        }
        ServletOps.success(action);
    }

    @Override
    protected void doDelete(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execDeleteQuads(action);
        } else {
            this.execDeleteGSP(action);
        }
    }

    @Override
    protected void doPut(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execPutQuads(action);
        } else {
            this.execPutGSP(action);
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        if (GSP_RW.isQuads(action)) {
            this.execPostQuads(action);
        } else {
            this.execPostGSP(action);
        }
    }

    protected void execPostGSP(HttpAction action) {
        this.doPutPostGSP(action, false);
    }

    protected void execPostQuads(HttpAction action) {
        this.doPutPostQuads(action, false);
    }

    protected void execPutGSP(HttpAction action) {
        this.doPutPostGSP(action, true);
    }

    protected void execPutQuads(HttpAction action) {
        this.doPutPostQuads(action, true);
    }

    protected void execDelete(Supplier<DatasetGraph> dataset, HttpAction action) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execDeleteGSP(HttpAction action) {
        action.beginWrite();
        boolean haveCommited = false;
        try {
            boolean existedBefore;
            DatasetGraph dsg = this.decideDataset(action);
            GSPTarget target = GSP_RW.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("DELETE->" + target);
            }
            if (!(existedBefore = target.exists())) {
                action.commit();
                haveCommited = true;
                ServletOps.errorNotFound("No such graph: " + target.name);
            }
            GSP_RW.deleteGraph(dsg, action);
            action.commit();
            haveCommited = true;
        }
        catch (ActionErrorException ex) {
            throw ex;
        }
        catch (Exception ex) {
            action.abort();
        }
        finally {
            action.end();
        }
        ServletOps.successNoContent(action);
    }

    protected void execDeleteQuads(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE");
    }

    public static boolean hasGSPParams(HttpAction action) {
        boolean hasParamGraph;
        boolean hasParamGraphDefault;
        if (action.request.getQueryString() == null) {
            return false;
        }
        boolean bl = hasParamGraphDefault = action.request.getParameter("default") != null;
        if (hasParamGraphDefault) {
            return true;
        }
        boolean bl2 = hasParamGraph = action.request.getParameter("graph") != null;
        return hasParamGraph;
    }

    public static boolean xasGSPParamsStrict(HttpAction action) {
        if (action.request.getQueryString() == null) {
            return false;
        }
        Map<String, String[]> params = action.request.getParameterMap();
        if (params.size() != 1) {
            return false;
        }
        boolean hasParamGraphDefault = GSPLib.hasExactlyOneValue(action, "default");
        boolean hasParamGraph = GSPLib.hasExactlyOneValue(action, "graph");
        return hasParamGraph ^ hasParamGraphDefault;
    }

    protected void doPutPostGSP(HttpAction action, boolean overwrite) {
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null) {
            ServletOps.errorBadRequest("No Content-Type:");
        }
        if (WebContent.matchContentType(WebContent.ctMultipartMixed, ct)) {
            ServletOps.error(415, "multipart/mixed not supported");
        }
        UploadDetails details = action.isTransactional() ? this.addDataIntoTxn(action, overwrite) : this.addDataIntoNonTxn(action, overwrite);
        MediaType mt = ConNeg.chooseCharset(action.request, DEF.jsonOffer, DEF.acceptJSON);
        if (mt == null) {
            if (details.getExistedBefore().equals((Object)UploadDetails.PreState.ABSENT)) {
                ServletOps.successCreated(action);
            } else {
                ServletOps.successNoContent(action);
            }
            return;
        }
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadDetails addDataIntoTxn(HttpAction action, boolean overwrite) {
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            GSPTarget target = GSP_RW.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug(action.request.getMethod().toUpperCase() + "->" + target);
            }
            boolean existedBefore = target.exists();
            Graph g = target.graph();
            if (overwrite && existedBefore) {
                GSP_RW.clearGraph(target);
            }
            StreamRDF sink = StreamRDFLib.graph(g);
            UploadDetails upload = Upload.incomingData(action, sink);
            upload.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = upload;
            return uploadDetails;
        }
        catch (ActionErrorException ex) {
            action.abort();
            throw ex;
        }
        catch (RiotException ex) {
            action.abort();
            ServletOps.errorBadRequest(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        catch (Exception ex) {
            action.abort();
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadDetails addDataIntoNonTxn(HttpAction action, boolean overwrite) {
        UploadDetails details;
        Graph graphTmp = GraphFactory.createGraphMem();
        StreamRDF dest = StreamRDFLib.graph(graphTmp);
        try {
            details = Upload.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return null;
        }
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            GSPTarget target = GSP_RW.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("  ->" + target);
            }
            boolean existedBefore = target.exists();
            if (overwrite && existedBefore) {
                GSP_RW.clearGraph(target);
            }
            FusekiNetLib.addDataInto(graphTmp, target.dsg, target.graphName);
            details.setExistedBefore(existedBefore);
            action.commit();
            UploadDetails uploadDetails = details;
            return uploadDetails;
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
            UploadDetails uploadDetails = null;
            return uploadDetails;
        }
        finally {
            action.end();
        }
    }

    protected static void deleteGraph(DatasetGraph dsg, HttpAction action) {
        GSPTarget target = GSP_RW.determineTarget(dsg, action);
        if (target.isDefault) {
            GSP_RW.clearGraph(target);
        } else {
            dsg.removeGraph(target.graphName);
        }
    }

    protected static void clearGraph(GSPTarget target) {
        Graph g = target.graph();
        g.getPrefixMapping().clearNsPrefixMap();
        g.clear();
    }

    protected void doPutPostQuads(HttpAction action, boolean overwrite) {
        if (!action.getDataService().allowUpdate()) {
            ServletOps.errorMethodNotAllowed(action.getMethod());
        }
        if (action.isTransactional()) {
            this.quadsPutPostTxn(action, overwrite);
        } else {
            this.quadsPutPostTxn(action, overwrite);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quadsPutPostTxn(HttpAction action, boolean clearFirst) {
        UploadDetails details = null;
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            if (clearFirst) {
                dsg.clear();
            }
            StreamRDF dest = StreamRDFLib.dataset(dsg);
            details = Upload.incomingData(action, dest);
            action.commit();
            ServletOps.success(action);
        }
        catch (RiotException ex) {
            action.abort();
            ServletOps.errorBadRequest(ex.getMessage());
        }
        catch (ActionErrorException ex) {
            action.abort();
            throw ex;
        }
        catch (Exception ex) {
            action.abort();
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.end();
        }
        ServletOps.uploadResponse(action, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quadsPutPostNonTxn(HttpAction action, boolean clearFirst) {
        UploadDetails details;
        DatasetGraph dsgTmp = DatasetGraphFactory.create();
        StreamRDF dest = StreamRDFLib.dataset(dsgTmp);
        try {
            details = Upload.incomingData(action, dest);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest(ex.getMessage());
            return;
        }
        action.beginWrite();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            if (clearFirst) {
                dsg.clear();
            }
            FusekiNetLib.addDataInto(dsgTmp, dsg);
            action.commit();
            ServletOps.success(action);
        }
        catch (Exception ex) {
            try {
                action.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServletOps.errorOccurred(ex.getMessage());
        }
        finally {
            action.end();
        }
        ServletOps.uploadResponse(action, details);
    }
}

