/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.atlas.web.TypedOutputStream;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.GSPTarget;
import org.apache.jena.fuseki.servlets.GSP_Base;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;

public class GSP_R
extends GSP_Base {
    @Override
    protected void doGet(HttpAction action) {
        if (GSP_R.isQuads(action)) {
            this.execGetQuads(action);
        } else {
            this.execGetGSP(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execGetQuads(HttpAction action) {
        ServletOutputStream output;
        ActionLib.setCommonHeaders(action.response);
        MediaType mediaType = ActionLib.contentNegotationQuads(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream(output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentType());
        if (lang == null) {
            lang = RDFLanguages.TRIG;
        }
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        if (!RDFLanguages.isQuads(lang)) {
            ServletOps.errorBadRequest("Not a quads format: " + mediaType);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = this.decideDataset(action);
            action.response.setHeader("Content-type", lang.getContentType().toHeaderString());
            RDFFormat fmt = lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization(lang);
            try {
                RDFDataMgr.write((OutputStream)out, dsg, fmt);
            }
            catch (JenaException ex) {
                if (fmt.getLang().equals(Lang.RDFXML)) {
                    ServletOps.errorBadRequest("Failed to write output in RDF/XML: " + ex.getMessage());
                }
                ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execGetGSP(HttpAction action) {
        ServletOutputStream output;
        ActionLib.setCommonHeaders(action.response);
        MediaType mediaType = ActionLib.contentNegotationRDF(action);
        try {
            output = action.response.getOutputStream();
        }
        catch (IOException ex) {
            ServletOps.errorOccurred(ex);
            output = null;
        }
        TypedOutputStream out = new TypedOutputStream(output, mediaType);
        Lang lang = RDFLanguages.contentTypeToLang(mediaType.getContentType());
        action.beginRead();
        if (action.verbose) {
            action.log.info(String.format("[%d]   Get: Content-Type=%s, Charset=%s => %s", action.id, mediaType.getContentType(), mediaType.getCharset(), lang.getName()));
        }
        try {
            boolean exists;
            DatasetGraph dsg = this.decideDataset(action);
            GSPTarget target = GSP_R.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("GET->" + target);
            }
            if (!(exists = target.exists())) {
                ServletOps.errorNotFound("No such graph: <" + target.name + ">");
            }
            Graph g = target.graph();
            if (!target.isDefault && g.isEmpty()) {
                ServletOps.errorNotFound("No such graph: <" + target.name + ">");
            }
            String ct = lang.getContentType().toHeaderString();
            action.response.setContentType(ct);
            RDFFormat fmt = lang == Lang.RDFXML ? RDFFormat.RDFXML_PLAIN : RDFWriterRegistry.defaultSerialization(lang);
            try {
                RDFDataMgr.write((OutputStream)out, g, fmt);
            }
            catch (JenaException ex) {
                if (fmt.getLang().equals(Lang.RDFXML)) {
                    ServletOps.errorBadRequest("Failed to write output in RDF/XML: " + ex.getMessage());
                }
                ServletOps.errorOccurred("Failed to write output: " + ex.getMessage(), ex);
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
        ServletOps.success(action);
    }

    @Override
    protected void doHead(HttpAction action) {
        if (GSP_R.isQuads(action)) {
            this.execHeadQuads(action);
        } else {
            this.execHeadGSP(action);
        }
    }

    protected void execHeadQuads(HttpAction action) {
        ActionLib.setCommonHeaders(action.response);
        MediaType mediaType = ActionLib.contentNegotationQuads(action);
        if (action.verbose) {
            action.log.info(String.format("[%d]   Head: Content-Type=%s", action.id, mediaType.getContentType()));
        }
        ServletOps.success(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execHeadGSP(HttpAction action) {
        ActionLib.setCommonHeaders(action.response);
        MediaType mediaType = ActionLib.contentNegotationRDF(action);
        if (action.verbose) {
            action.log.info(String.format("[%d]   Head: Content-Type=%s", action.id, mediaType.getContentType()));
        }
        action.beginRead();
        try {
            boolean exists;
            DatasetGraph dsg = this.decideDataset(action);
            GSPTarget target = GSP_R.determineTarget(dsg, action);
            if (action.log.isDebugEnabled()) {
                action.log.debug("HEAD->" + target);
            }
            if (!(exists = target.exists())) {
                ServletOps.errorNotFound("No such graph: <" + target.name + ">");
            }
            ServletOps.success(action);
        }
        finally {
            action.endRead();
        }
    }

    @Override
    protected void doPost(HttpAction action) {
        ServletOps.errorMethodNotAllowed("POST : Read-only");
    }

    @Override
    protected void doDelete(HttpAction action) {
        ServletOps.errorMethodNotAllowed("DELETE : Read-only");
    }

    @Override
    protected void doPut(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PUT : Read-only");
    }

    @Override
    protected void doPatch(HttpAction action) {
        ServletOps.errorMethodNotAllowed("PATCH : Read-only");
    }
}

