/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.servlets.ActionREST;
import org.apache.jena.fuseki.servlets.GSPLib;
import org.apache.jena.fuseki.servlets.GSPTarget;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.SPARQLProtocol;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.DatasetGraph;

public abstract class GSP_Base
extends ActionREST {
    protected GSP_Base() {
    }

    @Override
    public void validate(HttpAction action) {
        if (GSP_Base.isQuads(action)) {
            GSP_Base.validateQuads(action);
        } else {
            GSP_Base.validateGSP(action);
        }
    }

    protected static boolean isQuads(HttpAction action) {
        return action.request.getQueryString() == null;
    }

    private static void validateQuads(HttpAction action) {
    }

    private static void validateGSP(HttpAction action) {
        HttpServletRequest request = action.request;
        if (request.getQueryString() == null) {
            ServletOps.errorBadRequest("No query string. ?default or ?graph required.");
        }
        String g = request.getParameter("graph");
        String d = request.getParameter("default");
        if (g != null && d != null) {
            ServletOps.errorBadRequest("Both ?default and ?graph in the query string of the request");
        }
        if (g == null && d == null) {
            ServletOps.errorBadRequest("Neither ?default nor ?graph in the query string of the request");
        }
        int x1 = SPARQLProtocol.countParamOccurences(request, "graph");
        int x2 = SPARQLProtocol.countParamOccurences(request, "default");
        if (x1 > 1) {
            ServletOps.errorBadRequest("Multiple ?default in the query string of the request");
        }
        if (x2 > 1) {
            ServletOps.errorBadRequest("Multiple ?graph in the query string of the request");
        }
        Enumeration<String> en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String h = en.nextElement();
            if (!"graph".equals(h) && !"default".equals(h)) {
                ServletOps.errorBadRequest("Unknown parameter '" + h + "'");
            }
            if (request.getParameterValues(h).length == 1) continue;
            ServletOps.errorBadRequest("Multiple parameters '" + h + "'");
        }
    }

    protected static final GSPTarget determineTarget(DatasetGraph dsg, HttpAction action) {
        if (dsg == null) {
            ServletOps.errorOccurred("Internal error : No action graph (not in a transaction?)");
        }
        boolean dftGraph = GSPLib.getOneOnly(action.request, "default") != null;
        String uri = GSPLib.getOneOnly(action.request, "graph");
        if (!dftGraph && uri == null) {
            ServletOps.errorBadRequest("Neither default graph nor named graph specified");
            String directName = action.request.getRequestURL().toString();
            if (action.request.getRequestURI().equals(action.getDatasetName())) {
                ServletOps.errorBadRequest("Neither default graph nor named graph specified and no direct name");
            }
            Node gn = NodeFactory.createURI(directName);
            return GSP_Base.namedTarget(dsg, directName);
        }
        if (dftGraph) {
            return GSPTarget.createDefault(dsg);
        }
        if (uri.equals("default")) {
            return GSPTarget.createDefault(dsg);
        }
        String base = action.request.getRequestURL().toString();
        if (action.request.getQueryString() != null && !base.endsWith("/")) {
            base = base + "/";
        }
        String absUri = null;
        try {
            absUri = IRIResolver.resolveString(uri, base);
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest("Bad IRI: " + ex.getMessage());
        }
        return GSP_Base.namedTarget(dsg, absUri);
    }

    private static GSPTarget namedTarget(DatasetGraph dsg, String graphName) {
        Node gn = NodeFactory.createURI(graphName);
        return GSPTarget.createNamed(dsg, graphName, gn);
    }
}

