/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.DatasetGraph;

final class GSPTarget {
    final boolean isDefault;
    final DatasetGraph dsg;
    private Graph _graph;
    final String name;
    final Node graphName;

    static GSPTarget createNamed(DatasetGraph dsg, String name, Node graphName) {
        return new GSPTarget(false, dsg, name, graphName);
    }

    static GSPTarget createDefault(DatasetGraph dsg) {
        return new GSPTarget(true, dsg, null, null);
    }

    static GSPTarget retarget(GSPTarget target, DatasetGraph dsg) {
        GSPTarget target2 = new GSPTarget(target, dsg);
        target2._graph = null;
        return target2;
    }

    private GSPTarget(boolean isDefault, DatasetGraph dsg, String name, Node graphName) {
        this.isDefault = isDefault;
        this.dsg = dsg;
        this._graph = null;
        this.name = name;
        this.graphName = graphName;
        if (isDefault) {
            if (name != null || graphName != null) {
                throw new IllegalArgumentException("Inconsistent: default and a graph name/node");
            }
        } else if (name == null || graphName == null) {
            throw new IllegalArgumentException("Inconsistent: not default and/or no graph name/node");
        }
    }

    private GSPTarget(GSPTarget other, DatasetGraph dsg) {
        this.isDefault = other.isDefault;
        this.dsg = dsg;
        this._graph = other._graph;
        this.name = other.name;
        this.graphName = other.graphName;
    }

    public Graph graph() {
        if (!this.isGraphSet()) {
            this._graph = this.isDefault ? this.dsg.getDefaultGraph() : this.dsg.getGraph(this.graphName);
        }
        return this._graph;
    }

    public boolean exists() {
        if (this.isDefault) {
            return true;
        }
        return this.dsg.containsGraph(this.graphName);
    }

    public boolean isGraphSet() {
        return this._graph != null;
    }

    public String toString() {
        if (this.isDefault) {
            return "default";
        }
        return this.name;
    }
}

