/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.AcceptList;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.fuseki.DEF;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletBase;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.system.ConNeg;
import org.apache.jena.fuseki.system.FusekiNetLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.graph.GraphFactory;

public class ActionLib {
    public static String mapRequestToDataset(HttpAction action) {
        String uri = action.getActionURI();
        return ActionLib.mapRequestToDataset(uri);
    }

    public static String mapRequestToDataset(String uri) {
        int i = uri.lastIndexOf(47);
        if (i == -1) {
            return null;
        }
        if (i == 0) {
            return uri;
        }
        return uri.substring(0, i);
    }

    public static String mapRequestToEndpointName(HttpAction action, DataAccessPoint dsRef) {
        if (dsRef == null) {
            return "";
        }
        String uri = action.getActionURI();
        String name = dsRef.getName();
        if (name.length() >= uri.length()) {
            return "";
        }
        return uri.substring(name.length() + 1);
    }

    public static String mapRequestToDatasetLongest$(String uri, DataAccessPointRegistry registry) {
        if (uri == null) {
            return null;
        }
        String ds = null;
        for (String ds2 : registry.keys()) {
            if (!uri.startsWith(ds2)) continue;
            if (ds == null) {
                ds = ds2;
                continue;
            }
            if (ds.length() >= ds2.length()) continue;
            ds = ds2;
        }
        return ds;
    }

    public static String wholeRequestURL(HttpServletRequest request) {
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null) {
            sb.append("?");
            sb.append(queryString);
        }
        return sb.toString();
    }

    public static String removeContextPath(HttpAction action) {
        return ActionLib.actionURI(action.request);
    }

    public static String actionURI(HttpServletRequest request) {
        String contextPath = request.getServletContext().getContextPath();
        String uri = request.getRequestURI();
        if (contextPath == null) {
            return uri;
        }
        if (contextPath.isEmpty()) {
            return uri;
        }
        String x = uri;
        if (uri.startsWith(contextPath)) {
            x = uri.substring(contextPath.length());
        }
        return x;
    }

    public static MediaType contentNegotation(HttpAction action, AcceptList myPrefs, MediaType defaultMediaType) {
        MediaType mt = ConNeg.chooseContentType(action.request, myPrefs, defaultMediaType);
        if (mt == null) {
            return null;
        }
        if (mt.getContentType() != null) {
            action.response.setContentType(mt.getContentType());
        }
        if (mt.getCharset() != null) {
            action.response.setCharacterEncoding(mt.getCharset());
        }
        return mt;
    }

    public static MediaType contentNegotationRDF(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.rdfOffer, DEF.acceptRDFXML);
    }

    public static MediaType contentNegotationQuads(HttpAction action) {
        return ActionLib.contentNegotation(action, DEF.quadsOffer, DEF.acceptNQuads);
    }

    public static void parse(HttpAction action, StreamRDF dest, InputStream input, Lang lang, String base) {
        try {
            if (!RDFParserRegistry.isRegistered(lang)) {
                ServletOps.errorBadRequest("No parser for language '" + lang.getName() + "'");
            }
            ErrorHandler errorHandler = ErrorHandlerFactory.errorHandlerStd(action.log);
            RDFParser.create().errorHandler(errorHandler).source(input).lang(lang).base(base).parse(dest);
        }
        catch (RuntimeIOException ex) {
            if (ex.getCause() instanceof CharacterCodingException) {
                throw new RiotException("Character Coding Error: " + ex.getMessage());
            }
            throw ex;
        }
        catch (RiotException ex) {
            ServletOps.errorBadRequest("Parse error: " + ex.getMessage());
        }
    }

    public static Graph readFromRequest(HttpAction action, Lang defaultLang) {
        Lang lang;
        ContentType ct = ActionLib.getContentType(action);
        if (ct == null || ct.getContentTypeStr().isEmpty()) {
            lang = RDFLanguages.TURTLE;
        } else {
            if (ct.equals(WebContent.ctHTMLForm)) {
                ServletOps.errorBadRequest("HTML Form data sent to SHACL valdiation server");
                return null;
            }
            lang = RDFLanguages.contentTypeToLang(ct.getContentTypeStr());
            if (lang == null) {
                lang = defaultLang;
            }
        }
        ServletInputStream input = null;
        try {
            input = action.request.getInputStream();
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(graph);
        ActionLib.parse(action, dest, input, lang, null);
        return graph;
    }

    public static void graphResponse(HttpAction action, Graph graph, Lang lang) {
        action.response.setContentType(lang.getContentType().getContentTypeStr());
        try {
            RDFDataMgr.write((OutputStream)action.response.getOutputStream(), graph, lang);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static String getOneHeader(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            ServletOps.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }

    public static ContentType getContentType(HttpAction action) {
        return FusekiNetLib.getContentType(action.request);
    }

    public static void setCommonHeadersForOptions(HttpServletResponse httpResponse) {
        ActionLib.setCommonHeaders(httpResponse);
    }

    public static void setCommonHeaders(HttpServletResponse httpResponse) {
        if (Fuseki.outputFusekiServerHeader) {
            httpResponse.setHeader("Server", Fuseki.serverHttpName);
        }
    }

    private static String extractItemName(HttpAction action) {
        String x1 = action.request.getServletPath();
        String x2 = action.request.getPathInfo();
        String pathInfo = action.request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty() || pathInfo.equals("/")) {
            return null;
        }
        String name = pathInfo;
        int idx = pathInfo.lastIndexOf(47);
        if (idx > 0) {
            name = name.substring(idx);
        }
        return name;
    }

    public static void doOptionsGet(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,OPTIONS");
    }

    public static void doOptionsGetHead(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,OPTIONS");
    }

    public static void doOptionsGetPost(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,POST,OPTIONS");
    }

    public static void doOptionsGetPostHead(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,POST,HEAD,OPTIONS");
    }

    public static void doOptionsGetPostDelete(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,POST,DELETE,OPTIONS");
    }

    public static void doOptionsGetPostDeleteHead(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "GET,HEAD,POST,DELETE,OPTIONS");
    }

    public static void doOptionsPost(HttpAction action) {
        ServletBase.setCommonHeadersForOptions(action.response);
        action.response.setHeader("Allow", "POST,OPTIONS");
    }
}

