/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionService;
import org.apache.jena.fuseki.servlets.GSP_R;
import org.apache.jena.fuseki.servlets.GSP_RW;
import org.apache.jena.fuseki.servlets.NoOpActionService;
import org.apache.jena.fuseki.servlets.SHACL_Validation;
import org.apache.jena.fuseki.servlets.SPARQL_QueryDataset;
import org.apache.jena.fuseki.servlets.SPARQL_Update;
import org.apache.jena.fuseki.servlets.SPARQL_Upload;

public class OperationRegistry {
    private static final ActionService queryServlet = new SPARQL_QueryDataset();
    private static final ActionService updateServlet = new SPARQL_Update();
    private static final ActionService uploadServlet = new SPARQL_Upload();
    private static final ActionService gspServlet_R = new GSP_R();
    private static final ActionService gspServlet_RW = new GSP_RW();
    private static final ActionService noOperation = new NoOpActionService();
    private static final ActionService shaclValidation = new SHACL_Validation();
    private static final OperationRegistry stdConfig = OperationRegistry.stdConfig();
    private final Map<String, Operation> contentTypeToOperation = new ConcurrentHashMap<String, Operation>();
    private final Map<Operation, ActionService> operationToHandler = new ConcurrentHashMap<Operation, ActionService>();

    public static OperationRegistry get() {
        return stdConfig;
    }

    private static OperationRegistry stdConfig() {
        OperationRegistry stdOpReg = new OperationRegistry();
        stdOpReg.register(Operation.Query, "application/sparql-query", queryServlet);
        stdOpReg.register(Operation.Update, "application/sparql-update", updateServlet);
        stdOpReg.register(Operation.Upload, null, uploadServlet);
        stdOpReg.register(Operation.Shacl, null, shaclValidation);
        stdOpReg.register(Operation.GSP_R, null, gspServlet_R);
        stdOpReg.register(Operation.GSP_RW, null, gspServlet_RW);
        stdOpReg.register(Operation.NoOp, null, noOperation);
        return stdOpReg;
    }

    public static void copyConfig(OperationRegistry src, OperationRegistry dst) {
        dst.contentTypeToOperation.putAll(src.contentTypeToOperation);
        dst.operationToHandler.putAll(src.operationToHandler);
    }

    public OperationRegistry(OperationRegistry other) {
        OperationRegistry.copyConfig(other, this);
    }

    public static OperationRegistry createStd() {
        OperationRegistry registry = new OperationRegistry();
        OperationRegistry.copyConfig(stdConfig, registry);
        return registry;
    }

    public static OperationRegistry createEmpty() {
        return new OperationRegistry();
    }

    private OperationRegistry() {
    }

    public Operation findByContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        return this.contentTypeToOperation.get(contentType);
    }

    public ActionService findHandler(Operation operation) {
        if (operation == null) {
            return null;
        }
        return this.operationToHandler.get(operation);
    }

    public boolean isRegistered(Operation operation) {
        return this.operationToHandler.containsKey(operation);
    }

    public void register(Operation operation, ActionService action) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(action);
        this.register(operation, null, action);
    }

    public void register(Operation operation, String contentType, ActionService action) {
        Objects.requireNonNull(operation);
        Objects.requireNonNull(action);
        if (contentType != null) {
            this.contentTypeToOperation.put(contentType, operation);
        } else {
            this.contentTypeToOperation.values().remove(operation);
        }
        this.operationToHandler.put(operation, action);
    }

    public void unregister(Operation operation) {
        Objects.requireNonNull(operation);
        this.operationToHandler.remove(operation);
        this.contentTypeToOperation.values().remove(operation);
    }

    public static OperationRegistry get(ServletContext servletContext) {
        OperationRegistry registry = (OperationRegistry)servletContext.getAttribute("org.apache.jena.fuseki:OperationRegistry");
        if (registry == null) {
            Log.warn(OperationRegistry.class, "No service registry for ServletContext");
        }
        return registry;
    }

    public static void set(ServletContext cxt, OperationRegistry registry) {
        cxt.setAttribute("org.apache.jena.fuseki:OperationRegistry", registry);
    }
}

