/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Collection;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;

public class EndpointSet {
    private final String name;
    private Endpoint single;
    private Map<Operation, Endpoint> endpoints = new ConcurrentHashMap<Operation, Endpoint>();

    public EndpointSet(String name) {
        this.name = name;
        this.single = null;
    }

    public void put(Endpoint endpoint) {
        Operation operation;
        if (this.name != null) {
            if (!endpoint.getName().equals(this.name)) {
                Log.warn(EndpointSet.class, "Different endpoint name: set = '" + this.name + "' : endpoint = '" + endpoint.getName() + "'");
            }
        } else if (!endpoint.isUnnamed()) {
            Log.warn(EndpointSet.class, "Different endpoint name: set = '' : endpoint = '" + endpoint.getName() + "'");
        }
        if (this.endpoints.containsKey(operation = endpoint.getOperation())) {
            Log.warn(EndpointSet.class, "Redefining endpoint for " + operation);
        }
        Endpoint endpointPrev = this.endpoints.put(operation, endpoint);
        this.resetSingle();
    }

    public void remove(Endpoint endpoint) {
        this.endpoints.remove(endpoint.getOperation());
        this.resetSingle();
    }

    public Endpoint get(Operation operation) {
        return this.endpoints.get(operation);
    }

    public boolean contains(Operation operation) {
        return this.endpoints.containsKey(operation);
    }

    public boolean isEmpty() {
        return this.endpoints.isEmpty();
    }

    public int size() {
        return this.endpoints.size();
    }

    public void forEach(BiConsumer<Operation, Endpoint> action) {
        this.endpoints.forEach(action);
    }

    private void resetSingle() {
        if (this.endpoints.size() == 1) {
            this.single = this.endpoints.values().iterator().next();
        } else if (this.single != null) {
            this.single = null;
        }
    }

    public Collection<Endpoint> endpoints() {
        return this.endpoints.values();
    }

    public Collection<Operation> operations() {
        return this.endpoints.keySet();
    }

    public Endpoint getOnly() {
        return this.single;
    }

    public String toString() {
        String x = this.name == null ? "" : this.name;
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        this.operations().forEach((? super T op) -> sj.add(op.toString()));
        return x + sj.toString();
    }
}

