/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.sparql.util.Context;

public class EndpointBuilder {
    private Context context = null;
    private Operation operation = null;
    private String endpointName = null;
    private AuthPolicy authPolicy = null;
    private ActionProcessor processor = null;

    public static EndpointBuilder create() {
        return new EndpointBuilder();
    }

    private EndpointBuilder() {
    }

    public EndpointBuilder operation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public EndpointBuilder endpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public EndpointBuilder context(Context context2) {
        this.context = context2;
        return this;
    }

    public EndpointBuilder authPolicy(AuthPolicy authPolicy) {
        this.authPolicy = authPolicy;
        return this;
    }

    public EndpointBuilder processor(ActionProcessor processor) {
        this.processor = processor;
        return this;
    }

    public Context context() {
        return this.context;
    }

    public Operation operation() {
        return this.operation;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public AuthPolicy authPolicy() {
        return this.authPolicy;
    }

    public ActionProcessor processor() {
        return this.processor;
    }

    public Endpoint build() {
        Objects.requireNonNull(this.operation, "Operation for Endpoint");
        return new Endpoint(this.operation, this.endpointName, this.authPolicy, this.processor, this.context);
    }
}

