/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Objects;
import org.apache.jena.fuseki.auth.AuthPolicy;
import org.apache.jena.fuseki.server.CounterName;
import org.apache.jena.fuseki.server.CounterSet;
import org.apache.jena.fuseki.server.Counters;
import org.apache.jena.fuseki.server.EndpointBuilder;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.sparql.util.Context;

public class Endpoint
implements Counters {
    public static final String DatasetEP = "";
    private final Operation operation;
    private ActionProcessor processor = null;
    private final String endpointName;
    private final AuthPolicy authPolicy;
    private final Context context;
    private final CounterSet counters = new CounterSet();

    public static EndpointBuilder create() {
        return EndpointBuilder.create();
    }

    public static Endpoint create(Operation operation, String endpointName, AuthPolicy requestAuth) {
        return EndpointBuilder.create().operation(operation).endpointName(endpointName).authPolicy(requestAuth).build();
    }

    Endpoint(Operation operation, String endpointName, AuthPolicy requestAuth, ActionProcessor processor, Context context2) {
        this.operation = Objects.requireNonNull(operation, "operation");
        this.endpointName = endpointName == null ? DatasetEP : endpointName;
        this.authPolicy = requestAuth;
        this.context = context2;
        this.processor = processor;
        this.counters.add(CounterName.Requests);
        this.counters.add(CounterName.RequestsGood);
        this.counters.add(CounterName.RequestsBad);
    }

    @Override
    public CounterSet getCounters() {
        return this.counters;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public ActionProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(ActionProcessor proc) {
        this.processor = proc;
    }

    public Context getContext() {
        return this.context;
    }

    public boolean isUnnamed() {
        return this.endpointName == null || this.endpointName.isEmpty();
    }

    public String getName() {
        return this.isUnnamed() ? DatasetEP : this.endpointName;
    }

    public AuthPolicy getAuthPolicy() {
        return this.authPolicy;
    }

    public long getRequests() {
        return this.counters.value(CounterName.Requests);
    }

    public long getRequestsGood() {
        return this.counters.value(CounterName.RequestsGood);
    }

    public long getRequestsBad() {
        return this.counters.value(CounterName.RequestsBad);
    }

    public String toString() {
        return this.getName() + "[" + this.operation + "]";
    }
}

