/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.EndpointSet;
import org.apache.jena.fuseki.server.Operation;
import org.apache.jena.fuseki.servlets.ActionErrorException;
import org.apache.jena.fuseki.servlets.ActionExecLib;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionProcessor;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.slf4j.Logger;

public class Dispatcher {
    private static final boolean LogDispatch = false;
    private static Logger LOG = Fuseki.serverLog;

    public static boolean dispatch(HttpServletRequest request, HttpServletResponse response) {
        String uri = ActionLib.actionURI(request);
        String datasetUri = ActionLib.mapRequestToDataset(uri);
        if (datasetUri == null) {
            return false;
        }
        DataAccessPointRegistry registry = DataAccessPointRegistry.get(request.getServletContext());
        if (!registry.isRegistered(datasetUri)) {
            return false;
        }
        DataAccessPoint dap = registry.get(datasetUri);
        return Dispatcher.process(dap, request, response);
    }

    private static boolean process(DataAccessPoint dap, HttpServletRequest request, HttpServletResponse response) {
        HttpAction action = ActionExecLib.allocHttpAction(dap, Fuseki.actionLog, request, response);
        return Dispatcher.dispatchAction(action);
    }

    public static boolean dispatchAction(HttpAction action) {
        return ActionExecLib.execAction(action, () -> Dispatcher.chooseProcessor(action));
    }

    private static ActionProcessor chooseProcessor(HttpAction action) {
        ActionProcessor processor;
        DataAccessPoint dataAccessPoint = action.getDataAccessPoint();
        DataService dataService = action.getDataService();
        if (!dataService.isAcceptingRequests()) {
            ServletOps.error(503, "Dataset not currently active");
            return null;
        }
        String endpointName = Dispatcher.mapRequestToEndpointName(action, dataAccessPoint);
        Endpoint endpoint = Dispatcher.chooseEndpoint(action, dataService, endpointName);
        if (endpoint == null) {
            if (!StringUtils.isEmpty(endpointName)) {
                return null;
            }
            ServletOps.errorBadRequest("No operation for request: " + action.getActionURI());
            return null;
        }
        Operation operation = endpoint.getOperation();
        if (operation == null) {
            ServletOps.errorNotFound("No operation: " + action.getActionURI());
            return null;
        }
        action.setEndpoint(endpoint);
        String user = action.getUser();
        if (dataService.authPolicy() != null && !dataService.authPolicy().isAllowed(user)) {
            ServletOps.errorForbidden();
        }
        Auth.allow(user, action.getEndpoint().getAuthPolicy(), ServletOps::errorForbidden);
        if (StringUtils.isEmpty(endpointName) && !endpoint.isUnnamed()) {
            Collection<Endpoint> x = Dispatcher.getEndpoints(dataService, operation);
            if (x.isEmpty()) {
                throw new InternalErrorException("Inconsistent: no endpoints for " + operation);
            }
            x.forEach(ept -> Auth.allow(user, ept.getAuthPolicy(), ServletOps::errorForbidden));
        }
        if ((processor = endpoint.getProcessor()) == null) {
            ServletOps.errorBadRequest(String.format("No processor: dataset=%s: op=%s", dataAccessPoint.getName(), operation.getName()));
        }
        return processor;
    }

    protected static String mapRequestToEndpointName(HttpAction action, DataAccessPoint dataAccessPoint) {
        return ActionLib.mapRequestToEndpointName(action, dataAccessPoint);
    }

    private static Collection<Endpoint> getEndpoints(DataService dataService, Operation operation) {
        List<Endpoint> x = dataService.getEndpoints(operation);
        if ((x == null || x.isEmpty()) && operation == Operation.GSP_R) {
            x = dataService.getEndpoints(Operation.GSP_RW);
        }
        return x;
    }

    private static Endpoint chooseEndpoint(HttpAction action, DataService dataService, String endpointName) {
        Endpoint ep = Dispatcher.chooseEndpointNoLegacy(action, dataService, endpointName);
        if (ep != null) {
            return ep;
        }
        if (!StringUtils.isEmpty(endpointName)) {
            return ep;
        }
        Operation operation = Dispatcher.chooseOperation(action);
        ep = Dispatcher.findEndpointForOperation(action, dataService, operation, true);
        return ep;
    }

    private static Endpoint chooseEndpointNoLegacy(HttpAction action, DataService dataService, String endpointName) {
        EndpointSet epSet;
        EndpointSet endpointSet = epSet = StringUtils.isEmpty(endpointName) ? dataService.getEndpointSet() : dataService.getEndpointSet(endpointName);
        if (epSet == null || epSet.isEmpty()) {
            return null;
        }
        Endpoint ep = epSet.getOnly();
        if (ep != null) {
            return ep;
        }
        Operation operation = Dispatcher.chooseOperation(action);
        ep = epSet.get(operation);
        if (ep == null && Operation.GSP_R.equals(operation)) {
            ep = epSet.get(Operation.GSP_RW);
        }
        return ep;
    }

    private static Endpoint findEndpointForOperation(HttpAction action, DataService dataService, Operation operation, boolean preferUnnamed) {
        Endpoint ep = Dispatcher.findEndpointForOperationExact(dataService, operation, preferUnnamed);
        if (ep != null) {
            return ep;
        }
        if (Operation.GSP_R.equals(operation)) {
            return Dispatcher.findEndpointForOperationExact(dataService, Operation.GSP_RW, preferUnnamed);
        }
        if (Operation.GSP_RW.equals(operation) && dataService.hasOperation(Operation.GSP_R)) {
            ServletOps.errorMethodNotAllowed(action.getMethod());
        }
        return null;
    }

    private static Endpoint findEndpointForOperationExact(DataService dataService, Operation operation, boolean preferUnnamed) {
        List<Endpoint> eps = dataService.getEndpoints(operation);
        if (eps == null || eps.isEmpty()) {
            return null;
        }
        Endpoint epAlt = null;
        for (Endpoint ep : eps) {
            if (!operation.equals(ep.getOperation())) continue;
            if (ep.isUnnamed() && preferUnnamed) {
                return ep;
            }
            if (!ep.isUnnamed() && !preferUnnamed) {
                return ep;
            }
            epAlt = ep;
        }
        return epAlt;
    }

    public static Operation chooseOperation(HttpAction action) {
        boolean hasParams;
        boolean hasParamGraphDefault;
        Operation operation;
        boolean isUpdate;
        boolean isQuery;
        HttpServletRequest request = action.getRequest();
        boolean bl = isQuery = request.getParameter("query") != null;
        if (isQuery) {
            return Operation.Query;
        }
        boolean bl2 = isUpdate = request.getParameter("update") != null || request.getParameter("request") != null;
        if (isUpdate) {
            return Operation.Update;
        }
        String ct = request.getContentType();
        if (ct != null && (operation = action.getOperationRegistry().findByContentType(ct)) != null) {
            return operation;
        }
        boolean hasParamGraph = request.getParameter("graph") != null;
        boolean bl3 = hasParamGraphDefault = request.getParameter("default") != null;
        if (hasParamGraph || hasParamGraphDefault) {
            return Dispatcher.gspOperation(action, request);
        }
        boolean bl4 = hasParams = request.getParameterMap().size() > 0;
        if (hasParams) {
            ServletOps.errorBadRequest("Malformed request: unrecognized query string parameters: " + request.getQueryString());
        }
        return Dispatcher.quadsOperation(action, request);
    }

    private static Operation gspOperation(HttpAction action, HttpServletRequest request) throws ActionErrorException {
        if (Dispatcher.isReadMethod(request)) {
            return Operation.GSP_R;
        }
        return Operation.GSP_RW;
    }

    private static Operation quadsOperation(HttpAction action, HttpServletRequest request) throws ActionErrorException {
        if (Dispatcher.isReadMethod(request)) {
            return Operation.GSP_R;
        }
        return Operation.GSP_RW;
    }

    private static boolean isReadMethod(HttpServletRequest request) {
        String method = request.getMethod();
        boolean isGET = method.equals("GET");
        boolean isHEAD = method.equals("HEAD");
        return isGET || isHEAD;
    }
}

