/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.jetty;

import org.apache.jena.fuseki.jetty.JettyLib;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttps {
    public static Server jettyServerHttps(ServletContextHandler handler, String keystore, String certPassword, int httpPort, int httpsPort) {
        Server jettyServer = JettyHttps.server(keystore, certPassword, httpPort, httpsPort);
        if (httpPort > 0) {
            SecuredRedirectHandler srh = new SecuredRedirectHandler();
            JettyLib.addHandler(jettyServer, srh);
        }
        JettyLib.addHandler(jettyServer, handler);
        return jettyServer;
    }

    private static Server server(String keystore, String certPassword, int httpPort, int httpsPort) {
        Server server = new Server();
        if (httpPort > 0) {
            ServerConnector plainConnector = JettyHttps.httpConnector(server, httpPort, httpsPort);
            server.addConnector(plainConnector);
        }
        ServerConnector httpsConnector = JettyHttps.httpsConnector(server, httpsPort, keystore, certPassword);
        server.addConnector(httpsConnector);
        return server;
    }

    private static ServerConnector httpConnector(Server server, int httpPort, int httpsPort) {
        HttpConfiguration http_config = JettyHttps.httpConfiguration();
        http_config.setSendServerVersion(false);
        if (httpPort > 0) {
            http_config.setSecureScheme(HttpScheme.HTTPS.asString());
            http_config.setSecurePort(httpsPort);
        }
        ServerConnector plainConnector = new ServerConnector(server, new HttpConnectionFactory(http_config));
        plainConnector.setPort(httpPort);
        return plainConnector;
    }

    private static ServerConnector httpsConnector(Server server, int httpsPort, String keystore, String certPassword) {
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword(certPassword);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setStsMaxAge(2000L);
        src.setStsIncludeSubDomains(true);
        HttpConfiguration https_config = JettyHttps.httpConfiguration();
        https_config.setSecureScheme(HttpScheme.HTTPS.asString());
        https_config.setSecurePort(httpsPort);
        https_config.addCustomizer(src);
        ServerConnector sslConnector = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config));
        sslConnector.setPort(httpsPort);
        return sslConnector;
    }

    private static HttpConfiguration httpConfiguration() {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setRequestHeaderSize(524288);
        http_config.setOutputBufferSize(0x100000);
        http_config.setSendServerVersion(false);
        return http_config;
    }
}

