/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.async.AsyncTask;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.ctl.Async;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.slf4j.Logger;

public class ActionSleep
extends ActionCtl {
    @Override
    public void execOptions(HttpAction action) {
        ActionLib.doOptionsPost(action);
        ServletOps.success(action);
    }

    @Override
    public void execPost(HttpAction action) {
        super.executeLifecycle(action);
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    public void execute(HttpAction action) {
        Runnable task = this.createRunnable(action);
        AsyncTask aTask = Async.execASyncTask(action, AsyncPool.get(), "sleep", task);
        JsonValue v = Async.asJson(aTask);
        Async.setLocationHeader(action, aTask);
        ServletOps.sendJsonReponse(action, v);
    }

    protected Runnable createRunnable(HttpAction action) {
        String interval = action.request.getParameter("interval");
        int sleepMilli = 5000;
        if (interval != null) {
            try {
                sleepMilli = Integer.parseInt(interval);
            }
            catch (NumberFormatException ex) {
                action.log.error(String.format("[%d] NumberFormatException: %s", action.id, interval));
            }
        }
        action.log.info(String.format("[%d] Sleep %d ms", action.id, sleepMilli));
        return new SleepTask(action, sleepMilli);
    }

    static class SleepTask
    implements Runnable {
        private final Logger log;
        private final long actionId;
        private final int sleepMilli;

        public SleepTask(HttpAction action, int sleepMilli) {
            this.log = action.log;
            this.actionId = action.id;
            this.sleepMilli = sleepMilli;
        }

        @Override
        public void run() {
            try {
                this.log.info(String.format("[%d] >> Sleep start", this.actionId));
                Lib.sleep(this.sleepMilli);
                this.log.info(String.format("[%d] << Sleep finish", this.actionId));
            }
            catch (Exception ex) {
                this.log.info(String.format("[%d] **** Exception", this.actionId), ex);
            }
        }
    }
}

