/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.fuseki.system.FusekiNetLib;

public class ActionDumpRequest
extends HttpServlet {
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doPrintInformation(req, resp);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doPrintInformation(req, resp);
    }

    public void doPrintInformation(HttpServletRequest req, HttpServletResponse resp) {
        try {
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html");
            String now2 = new Date().toString();
            out.println("<html>");
            out.println("<head>");
            out.println("<Title>Dump @ " + now2 + "</Title>");
            out.println("<meta CONTENT=now HTTP-EQUIV=expires>");
            out.println("</head>");
            out.println("<body>");
            out.println("<pre>");
            out.println("Dump : " + now2);
            out.println();
            out.println("==== Request");
            out.println();
            ActionDumpRequest.printRequest(out, req);
            out.println();
            out.println(">>>> Body");
            out.println();
            ActionDumpRequest.printBody(out, req);
            out.println("<<<< Body");
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printRequest(PrintWriter pw, HttpServletRequest req) {
        pw.println("Method:                 " + req.getMethod());
        pw.println("getContentLength:       " + Long.toString(req.getContentLengthLong()));
        pw.println("getContentType:         " + req.getContentType());
        pw.println("getRequestURI:          " + req.getRequestURI());
        pw.println("getRequestURL:          " + req.getRequestURL());
        pw.println("getContextPath:         " + req.getContextPath());
        pw.println("getServletPath:         " + req.getServletPath());
        pw.println("getPathInfo:            " + req.getPathInfo());
        pw.println("getPathTranslated:      " + req.getPathTranslated());
        pw.println("getQueryString:         " + req.getQueryString());
        pw.println("getProtocol:            " + req.getProtocol());
        pw.println("getScheme:              " + req.getScheme());
        pw.println("getServerName:          " + req.getServerName());
        pw.println("getServerPort:          " + req.getServerPort());
        pw.println("getRemoteUser:          " + req.getRemoteUser());
        pw.println("getRemoteAddr:          " + req.getRemoteAddr());
        pw.println("getRemoteHost:          " + req.getRemoteHost());
        pw.println("getRequestedSessionId:  " + req.getRequestedSessionId());
    }

    static void printBody(PrintWriter pw, HttpServletRequest req) throws IOException {
        String x;
        BufferedReader in = req.getReader();
        while ((x = in.readLine()) != null) {
            x = x.replaceAll("&", "&amp;");
            x = x.replaceAll("<", "&lt;");
            x = x.replaceAll(">", "&gt;");
            pw.println(x);
        }
    }

    static void printCookies(PrintWriter pw, HttpServletRequest req) {
        Cookie[] c = req.getCookies();
        if (c == null) {
            pw.println("getCookies:            <none>");
        } else {
            for (int i = 0; i < c.length; ++i) {
                pw.println();
                pw.println("Cookie:        " + c[i].getName());
                pw.println("    value:     " + c[i].getValue());
                pw.println("    version:   " + c[i].getVersion());
                pw.println("    comment:   " + c[i].getComment());
                pw.println("    domain:    " + c[i].getDomain());
                pw.println("    maxAge:    " + c[i].getMaxAge());
                pw.println("    path:      " + c[i].getPath());
                pw.println("    secure:    " + c[i].getSecure());
            }
        }
    }

    static void printHeaders(PrintWriter pw, HttpServletRequest req) {
        Enumeration<String> en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = req.getHeader(name);
            pw.println("Head: " + name + " = " + value);
        }
    }

    static void printParameters(PrintWriter pw, HttpServletRequest req) {
        Enumeration<String> en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = req.getParameter(name);
            pw.println("Param: " + name + " = " + value);
        }
    }

    static void printQueryString(PrintWriter pw, HttpServletRequest req) {
        Multimap<String, String> map = FusekiNetLib.parseQueryString(req);
        for (String name : map.keys()) {
            for (String value : map.get(name)) {
                pw.println("Param: " + name + " = " + value);
            }
        }
    }

    static void printLocales(PrintWriter pw, HttpServletRequest req) {
        Enumeration<Locale> en = req.getLocales();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            pw.println("Locale: " + name);
        }
        pw.println();
    }

    /*
     * Exception decompiling
     */
    public static String printEnvironment() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String printServletContext() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getServletInfo() {
        return "Dump";
    }
}

