/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockMgr;
import org.apache.jena.dboe.base.buffer.PtrBuffer;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.page.PageBlockMgr;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.sys.SystemIndex;
import org.apache.jena.dboe.trans.bplustree.AccessPath;
import org.apache.jena.dboe.trans.bplustree.BPT;
import org.apache.jena.dboe.trans.bplustree.BPTreeException;
import org.apache.jena.dboe.trans.bplustree.BPTreeNodeMgr;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;
import org.apache.jena.dboe.trans.bplustree.BPTreeRecords;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BPTreeNode
extends BPTreePage {
    private static Logger log = LoggerFactory.getLogger(BPTreeNode.class);
    Block block;
    int id;
    private int parent;
    private int count;
    private boolean isLeaf;
    private RecordBuffer records;
    PtrBuffer ptrs;

    @Override
    protected Logger getLogger() {
        return log;
    }

    void setRecordBuffer(RecordBuffer r) {
        this.records = r;
    }

    void setPtrBuffer(PtrBuffer pb) {
        this.ptrs = pb;
    }

    private BPTreeNode create(int parent, boolean isLeaf) {
        return BPTreeNode.create(this.bpTree, parent, isLeaf);
    }

    private static BPTreeNode create(BPlusTree bpTree, int parent, boolean isLeaf) {
        BPTreeNode n = bpTree.getNodeManager().createNode(parent);
        n.isLeaf = isLeaf;
        return n;
    }

    BPTreeNode(BPlusTree bpTree) {
        super(bpTree);
    }

    @Override
    public void reset(Block block) {
        this.block = block;
        BPTreeNodeMgr.formatBPTreeNode(this, this.bpTree, block, this.isLeaf, this.parent, this.count);
    }

    BPTreePage get(int idx) {
        int subId = this.ptrs.get(idx);
        PageBlockMgr<? extends BPTreePage> pbm = this.getPageBlockMgr();
        return pbm.getRead(subId, this.getId());
    }

    private PageBlockMgr<? extends BPTreePage> getPageBlockMgr() {
        if (this.isLeaf) {
            return this.bpTree.getRecordsMgr();
        }
        return this.bpTree.getNodeManager();
    }

    public static Record search(BPTreeNode root2, Record rec) {
        root2.internalCheckNodeDeep();
        if (!root2.isRoot()) {
            throw new BPTreeException("Search not starting from the root: " + root2);
        }
        AccessPath path = new AccessPath(root2);
        Record r = root2.internalSearch(path, rec);
        return r;
    }

    public static Record insert(BPTreeNode root2, Record record) {
        if (BPT.logging(log)) {
            BPT.log(log, "** insert(%s) / root=%d", record, root2.getId());
            if (BPT.DumpTree) {
                root2.dump();
            }
        }
        if (!root2.isRoot()) {
            throw new BPTreeException("Insert begins but this is not the root");
        }
        if (root2.isFull()) {
            BPTreeNode.splitRoot(root2);
            if (BPT.DumpTree) {
                root2.dump();
            }
        }
        AccessPath path = new AccessPath(root2);
        Record result = root2.internalInsert(path, record);
        root2.internalCheckNodeDeep();
        if (BPT.logging(log)) {
            BPT.log(log, "** insert(%s) / finish", record);
            if (BPT.DumpTree) {
                root2.dump();
            }
        }
        return result;
    }

    public static Record delete(BPTreeNode root2, Record rec) {
        if (BPT.logging(log)) {
            BPT.log(log, "** delete(%s) / start", rec);
            if (BPT.DumpTree) {
                root2.dump();
            }
        }
        if (!root2.isRoot()) {
            throw new BPTreeException("Delete begins but this is not the root");
        }
        AccessPath path = new AccessPath(root2);
        if (root2.isLeaf && root2.count == 0) {
            BPTreePage page = root2.get(0);
            if (BPT.CheckingNode && !(page instanceof BPTreeRecords)) {
                BPT.error("Zero size leaf root but not pointing to a records block", new Object[0]);
            }
            BPTreeNode.trackPath(path, root2, 0, page);
            Record r = page.internalDelete(path, rec);
            page.release();
            if (r != null) {
                root2.write();
            }
            if (BPT.DumpTree) {
                root2.dump();
            }
            return r;
        }
        Record v = root2.internalDelete(path, rec);
        if (!root2.isLeaf && root2.count == 0) {
            BPTreeNode.reduceRoot(root2);
            root2.bpTree.newRoot(root2);
            root2.internalCheckNodeDeep();
        }
        if (BPT.logging(log)) {
            BPT.log(log, "** delete(%s) / finish", rec);
            if (BPT.DumpTree) {
                root2.dump();
            }
        }
        return v;
    }

    Iterator<BPTreePage> iterator(Record minRec, Record maxRec) {
        if (minRec != null && maxRec != null && Record.keyGE(minRec, maxRec)) {
            return null;
        }
        int x1 = 0;
        if (minRec != null) {
            x1 = this.findSlot(minRec);
            x1 = BPT.apply(x1);
        }
        int x2 = this.getCount();
        if (maxRec != null) {
            x2 = this.findSlot(maxRec);
            x2 = BPT.apply(x2);
        }
        ArrayList<BPTreePage> x = new ArrayList<BPTreePage>(x2 - x1 + 1);
        for (int i = x1; i <= x2; ++i) {
            x.add(this.get(i));
        }
        return x.iterator();
    }

    static final Record minRecord(BPTreeNode root2) {
        AccessPath path = new AccessPath(root2);
        return root2.internalMinRecord(path);
    }

    static final Record maxRecord(BPTreeNode root2) {
        AccessPath path = new AccessPath(root2);
        return root2.internalMaxRecord(path);
    }

    @Override
    protected Record internalMaxRecord(AccessPath path) {
        BPTreePage page = this.get(this.count);
        BPTreeNode.trackPath(path, this, this.count, page);
        Record r = page.internalMaxRecord(path);
        page.release();
        return r;
    }

    @Override
    protected Record internalMinRecord(AccessPath path) {
        BPTreePage page = this.get(0);
        BPTreeNode.trackPath(path, this, 0, page);
        Record r = page.internalMinRecord(path);
        page.release();
        return r;
    }

    @Override
    final Record getLowRecord() {
        return this.records.getLow();
    }

    @Override
    final Record getHighRecord() {
        return this.records.getHigh();
    }

    @Override
    public final int getMaxSize() {
        return this.bpTree.getParams().getOrder();
    }

    @Override
    public final int getCount() {
        return this.count;
    }

    @Override
    public final void setCount(int count) {
        this.count = count;
    }

    @Override
    public Block getBackingBlock() {
        return this.block;
    }

    @Override
    public BlockMgr getBlockMgr() {
        return this.bpTree.getNodeManager().getBlockMgr();
    }

    public final RecordBuffer getRecordBuffer() {
        return this.records;
    }

    public final PtrBuffer getPtrBuffer() {
        return this.ptrs;
    }

    final void setParent(int parentId) {
        this.parent = parentId;
    }

    final int getParent() {
        return this.parent;
    }

    public final void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public final boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public String getRefStr() {
        return String.format("BPTNode[id=%d]", this.getBackingBlock().getId());
    }

    @Override
    final void write() {
        this.bpTree.getNodeManager().write(this);
    }

    private static final void trackPath(AccessPath path, BPTreeNode node, int idx, BPTreePage page) {
        if (path != null) {
            path.add(node, idx, page);
        }
    }

    private static final void resetTrackPath(AccessPath path, BPTreeNode node, int idx, BPTreePage page) {
        if (path != null) {
            path.reset(node, idx, page);
        }
    }

    @Override
    final boolean promote() {
        if (this.bpTree.getNodeManager().isWritable(this.getId())) {
            return false;
        }
        boolean promoteInPlace = this.bpTree.state().modifiableNodeBlock(this.getId());
        if (promoteInPlace) {
            this.bpTree.getNodeManager().promoteInPlace(this);
            return false;
        }
        Block oldBlock = this.block;
        boolean b = this.bpTree.getNodeManager().promoteDuplicate(this);
        if (b) {
            this.bpTree.getNodeManager().getBlockMgr().release(oldBlock);
        }
        return b;
    }

    @Override
    final void release() {
        this.bpTree.getNodeManager().release(this);
    }

    @Override
    final void free() {
        this.bpTree.getNodeManager().free(this);
    }

    @Override
    final Record internalSearch(AccessPath path, Record rec) {
        if (BPT.CheckingNode) {
            this.internalCheckNode();
        }
        BPTreePage page = this.findHere(path, rec);
        Record r = page.internalSearch(path, rec);
        page.release();
        return r;
    }

    private final BPTreePage findHere(AccessPath path, Record rec) {
        int idx = this.findSlot(rec);
        idx = BPT.apply(idx);
        BPTreePage page = this.get(idx);
        BPTreeNode.trackPath(path, this, idx, page);
        return page;
    }

    @Override
    final Record internalInsert(AccessPath path, Record record) {
        if (BPT.logging(log)) {
            BPT.log(log, "internalInsert: %s [%s]", record, this);
        }
        this.internalCheckNode();
        int idx = this.findSlot(record);
        if (BPT.logging(log)) {
            BPT.log(log, "internalInsert: idx=%d (=>%d)", idx, BPT.apply(idx));
        }
        idx = BPT.apply(idx);
        BPTreePage page = this.get(idx);
        BPTreeNode.trackPath(path, this, idx, page);
        if (BPT.logging(log)) {
            BPT.log(log, "internalInsert: next: %s", page);
        }
        if (page.isFull()) {
            this.split(path, idx, page);
            if (Record.keyGT(record, this.records.get(idx))) {
                page.release();
                page = this.get(++idx);
                path.reset(this, idx, page);
            }
            this.internalCheckNode();
        }
        Record r = page.internalInsert(path, record);
        page.release();
        return r;
    }

    private void split(AccessPath path, int idx, BPTreePage y) {
        if (BPT.logging(log)) {
            BPT.log(log, "split >> y=%s  this=%s idx=%d", y.getRefStr(), this.getRefStr(), idx);
            BPT.log(log, "split --   %s", y);
        }
        this.internalCheckNode();
        if (BPT.CheckingNode) {
            if (!y.isFull()) {
                BPT.error("Node is not full", new Object[0]);
            }
            if (this.ptrs.get(idx) != y.getId()) {
                int a = this.ptrs.get(idx);
                int b = y.getId();
                BPT.error("Node to be split isn't in right place [%d/%d]", a, b);
            }
        }
        this.internalCheckNodeDeep();
        BPT.promotePage(path, y);
        Record splitKey = y.getSplitKey();
        splitKey = this.keyRecord(splitKey);
        if (BPT.logging(log)) {
            BPT.log(log, "Split key: %s", splitKey);
        }
        BPTreePage z = y.split();
        if (BPT.logging(log)) {
            BPT.log(log, "Split: %s", y);
            BPT.log(log, "Split: %s", z);
        }
        if (splitKey.hasSeparateValue()) {
            splitKey = this.keyRecord(splitKey);
        }
        this.records.add(idx, splitKey);
        this.ptrs.add(idx + 1, z.getId());
        ++this.count;
        if (BPT.logging(log)) {
            BPT.log(log, "split <<   %s", this);
            BPT.log(log, "split <<   %s", y);
            BPT.log(log, "split <<   %s", z);
        }
        y.write();
        z.write();
        z.release();
        this.write();
        if (BPT.CheckingNode) {
            if (Record.keyNE(splitKey, y.maxRecord())) {
                BPT.error("Split key %d but max subtree %s", splitKey, y.maxRecord());
            }
            this.internalCheckNodeDeep();
        }
    }

    @Override
    final Record getSplitKey() {
        int ix = this.params.SplitIndex;
        Record split = this.records.get(ix);
        return split;
    }

    @Override
    final BPTreePage split() {
        int ix = this.params.SplitIndex;
        BPTreeNode z = this.create(this.parent, this.isLeaf);
        int maxRec = this.maxRecords();
        this.records.copy(ix + 1, z.records, 0, maxRec - (ix + 1));
        this.records.clear(ix, maxRec - ix);
        this.records.setSize(ix);
        this.ptrs.copy(ix + 1, z.ptrs, 0, this.params.MaxPtr - (ix + 1));
        this.ptrs.clear(ix + 1, this.params.MaxPtr - (ix + 1));
        this.ptrs.setSize(ix + 1);
        this.setCount(ix);
        this.internalCheckNode();
        z.isLeaf = this.isLeaf;
        z.setCount(maxRec - (ix + 1));
        z.internalCheckNode();
        return z;
    }

    private static void splitRoot(BPTreeNode root2) {
        BPlusTree bpTree = root2.bpTree;
        if (BPT.CheckingNode && !root2.isRoot()) {
            BPT.error("Not root: %d (root is id zero)", root2.getId());
        }
        root2.internalCheckNode();
        BPT.promoteRoot(root2);
        int splitIdx = root2.params.SplitIndex;
        Record rec = root2.records.get(splitIdx);
        if (BPT.logging(log)) {
            BPT.log(log, "** Split root %d (%s)", splitIdx, rec);
            BPT.log(log, "splitRoot >>   %s", root2);
        }
        BPTreeNode left = BPTreeNode.create(bpTree, root2.getId(), root2.isLeaf);
        BPTreeNode right = BPTreeNode.create(bpTree, root2.getId(), root2.isLeaf);
        root2.records.copy(0, left.records, 0, splitIdx);
        root2.ptrs.copy(0, left.ptrs, 0, splitIdx + 1);
        left.count = splitIdx;
        root2.records.copy(splitIdx + 1, right.records, 0, root2.maxRecords() - (splitIdx + 1));
        root2.ptrs.copy(splitIdx + 1, right.ptrs, 0, root2.params.MaxPtr - (splitIdx + 1));
        right.count = root2.maxRecords() - (splitIdx + 1);
        if (BPT.logging(log)) {
            BPT.log(log, "splitRoot -- left:   %s", left);
            BPT.log(log, "splitRoot -- right:  %s", right);
        }
        BPTreeNodeMgr.formatForRoot(root2, false);
        root2.count = 1;
        root2.records.add(0, rec);
        root2.ptrs.setSize(2);
        root2.ptrs.set(0, left.getId());
        root2.ptrs.set(1, right.getId());
        if (BPT.logging(log)) {
            BPT.log(log, "splitRoot <<   %s", root2);
            BPT.log(log, "splitRoot <<   %s", left);
            BPT.log(log, "splitRoot <<   %s", right);
        }
        left.write();
        right.write();
        left.release();
        right.release();
        root2.write();
        if (BPT.CheckingNode) {
            root2.internalCheckNode();
            left.internalCheckNode();
            right.internalCheckNode();
        }
    }

    @Override
    final Record internalDelete(AccessPath path, Record rec) {
        if (BPT.logging(log)) {
            BPT.log(log, ">> internalDelete(%s) : %s", rec, this);
        }
        this.internalCheckNode();
        int x = this.findSlot(rec);
        int y = BPT.apply(x);
        BPTreePage page = this.get(y);
        BPTreeNode.trackPath(path, this, y, page);
        if (page.isMinSize()) {
            this.rebalance(path, page, y);
            page.release();
            x = this.findSlot(rec);
            y = BPT.apply(x);
            page = this.get(y);
            BPT.promote1(page, this, y);
            BPTreeNode.resetTrackPath(path, this, y, page);
            if (BPT.CheckingNode) {
                this.internalCheckNode();
                page.checkNode();
            }
            this.write();
            page.write();
        }
        Record r2 = page.internalDelete(path, rec);
        if (x >= 0) {
            Record mx = page.maxRecord();
            this.records.set(x, this.keyRecord(mx));
            this.write();
        }
        if (BPT.logging(log)) {
            BPT.log(log, "<< internalDelete(%s) : %s", rec, this);
        }
        page.release();
        return r2;
    }

    private static void reduceRoot(BPTreeNode root2) {
        if (BPT.logging(log)) {
            BPT.log(log, "reduceRoot >> %s", root2);
        }
        if (BPT.CheckingNode && (!root2.isRoot() || root2.count != 0)) {
            BPT.error("Not an empty root", new Object[0]);
        }
        if (root2.isLeaf) {
            if (BPT.logging(log)) {
                BPT.log(log, "reduceRoot << leaf root", new Object[0]);
            }
            return;
        }
        BPT.promoteRoot(root2);
        BPTreePage sub = root2.get(0);
        BPT.promote1(sub, root2, 0);
        BPTreeNode n = BPTreeNode.cast(sub);
        BPTreeNodeMgr.formatForRoot(root2, n.isLeaf);
        n.records.copy(0, root2.records, 0, n.count);
        n.ptrs.copy(0, root2.ptrs, 0, n.count + 1);
        root2.isLeaf = n.isLeaf;
        root2.count = n.count;
        root2.write();
        n.free();
        if (BPT.CheckingNode) {
            root2.internalCheckNodeDeep();
        }
        if (BPT.logging(log)) {
            BPT.log(log, "reduceRoot << %s", root2);
        }
    }

    private BPTreePage rebalance(AccessPath path, BPTreePage node, int idx) {
        if (BPT.logging(log)) {
            BPT.log(log, "rebalance(id=%d, idx=%d)", node.getId(), idx);
            BPT.log(log, ">> this: %s", this);
            BPT.log(log, ">> node: %s", node);
        }
        this.internalCheckNode();
        BPT.promotePage(path, node);
        BPTreePage left = null;
        if (idx > 0) {
            left = this.get(idx - 1);
        }
        if (left != null && !left.isMinSize()) {
            if (BPT.logging(log)) {
                BPT.log(log, "rebalance/shiftRight", new Object[0]);
            }
            BPT.promote1(left, this, idx - 1);
            this.shiftRight(left, node, idx - 1);
            if (BPT.logging(log)) {
                BPT.log(log, "<< rebalance: %s", this);
            }
            if (BPT.CheckingNode) {
                left.checkNode();
                node.checkNode();
                this.internalCheckNode();
            }
            left.release();
            return node;
        }
        BPTreePage right = null;
        if (idx < this.count) {
            right = this.get(idx + 1);
        }
        if (right != null && !right.isMinSize()) {
            if (BPT.logging(log)) {
                BPT.log(log, "rebalance/shiftLeft", new Object[0]);
            }
            BPT.promote1(right, this, idx + 1);
            this.shiftLeft(node, right, idx);
            if (BPT.logging(log)) {
                BPT.log(log, "<< rebalance: %s", this);
            }
            if (BPT.CheckingNode) {
                right.checkNode();
                node.checkNode();
                this.internalCheckNode();
            }
            if (left != null) {
                left.release();
            }
            right.release();
            return node;
        }
        if (BPT.CheckingNode && left == null && right == null) {
            BPT.error("No siblings", new Object[0]);
        }
        if (left != null) {
            BPT.promote1(left, this, idx - 1);
            if (BPT.logging(log)) {
                BPT.log(log, "rebalance/merge/left: left=%d n=%d [%d]", left.getId(), node.getId(), idx - 1);
            }
            if (BPT.CheckingNode && left.getId() == node.getId()) {
                BPT.error("Left and n the same: %s", left);
            }
            BPTreePage page = this.merge(left, node, idx - 1);
            if (right != null) {
                right.release();
            }
            return page;
        }
        BPT.promote1(right, this, idx + 1);
        if (BPT.logging(log)) {
            BPT.log(log, "rebalance/merge/right: n=%d right=%d [%d]", node.getId(), right.getId(), idx);
        }
        if (BPT.CheckingNode && right.getId() == node.getId()) {
            BPT.error("N and right the same: %s", right);
        }
        BPTreePage page = this.merge(node, right, idx);
        return page;
    }

    private BPTreePage merge(BPTreePage left, BPTreePage right, int dividingSlot) {
        if (BPT.logging(log)) {
            BPT.log(log, ">> merge(@%d): %s", dividingSlot, this);
            BPT.log(log, ">> left:  %s", left);
            BPT.log(log, ">> right: %s", right);
        }
        Record splitKey = this.records.get(dividingSlot);
        BPTreePage page = left.merge(right, splitKey);
        if (BPT.logging(log)) {
            BPT.log(log, "-- merge: %s", page);
        }
        left.write();
        left.release();
        right.free();
        if (page == right) {
            BPT.error("Returned page is not the left", new Object[0]);
        }
        if (BPT.CheckingNode) {
            if (this.isLeaf) {
                if (left.getCount() + 1 != left.getMaxSize() && left.getCount() != left.getMaxSize()) {
                    BPT.error("Inconsistent data node size: %d/%d", left.getCount(), left.getMaxSize());
                }
            } else if (!left.isFull()) {
                BPT.error("Inconsistent node size: %d/%d", left.getCount(), left.getMaxSize());
            }
        }
        this.shuffleDown(dividingSlot);
        this.write();
        this.internalCheckNodeDeep();
        if (BPT.logging(log)) {
            BPT.log(log, "<< merge: %s", this);
            BPT.log(log, "<< left:  %s", left);
        }
        return left;
    }

    @Override
    BPTreePage merge(BPTreePage right, Record splitKey) {
        return BPTreeNode.merge(this, splitKey, BPTreeNode.cast(right));
    }

    private static BPTreeNode merge(BPTreeNode left, Record splitKey, BPTreeNode right) {
        left.records.add(splitKey);
        right.records.copyToTop(left.records);
        right.ptrs.copyToTop(left.ptrs);
        left.count = left.count + right.count + 1;
        left.internalCheckNode();
        right.records.clear();
        right.ptrs.clear();
        return left;
    }

    private void shiftRight(BPTreePage left, BPTreePage right, int i) {
        if (BPT.logging(log)) {
            BPT.log(log, ">> shiftRight: this:  %s", this);
            BPT.log(log, ">> shiftRight: left:  %s", left);
            BPT.log(log, ">> shiftRight: right: %s", right);
        }
        Record r1 = this.records.get(i);
        Record r2 = left.shiftRight(right, r1);
        r2 = this.keyRecord(r2);
        this.records.set(i, r2);
        left.write();
        right.write();
        if (BPT.logging(log)) {
            BPT.log(log, "<< shiftRight: this:  %s", this);
            BPT.log(log, "<< shiftRight: left:  %s", left);
            BPT.log(log, "<< shiftRight: right: %s", right);
        }
    }

    private void shiftLeft(BPTreePage left, BPTreePage right, int i) {
        if (BPT.logging(log)) {
            BPT.log(log, ">> shiftLeft: this:  %s", this);
            BPT.log(log, ">> shiftLeft: left:  %s", left);
            BPT.log(log, ">> shiftLeft: right: %s", right);
        }
        Record r1 = this.records.get(i);
        Record r2 = left.shiftLeft(right, r1);
        r2 = this.keyRecord(r2);
        this.records.set(i, r2);
        left.write();
        right.write();
        if (BPT.logging(log)) {
            BPT.log(log, "<< shiftLeft: this:  %s", this);
            BPT.log(log, "<< shiftLeft: left:  %s", left);
            BPT.log(log, "<< shiftLeft: right: %s", right);
        }
    }

    @Override
    Record shiftRight(BPTreePage other, Record splitKey) {
        BPTreeNode node = BPTreeNode.cast(other);
        if (BPT.CheckingNode) {
            if (this.count == 0) {
                BPT.error("Node is empty - can't shift a slot out", new Object[0]);
            }
            if (node.isFull()) {
                BPT.error("Destination node is full", new Object[0]);
            }
        }
        Record r = this.records.getHigh();
        this.records.removeTop();
        node.records.add(0, splitKey);
        this.ptrs.shiftRight(node.ptrs);
        --this.count;
        ++node.count;
        this.internalCheckNode();
        node.internalCheckNode();
        return r;
    }

    @Override
    Record shiftLeft(BPTreePage other, Record splitKey) {
        BPTreeNode node = BPTreeNode.cast(other);
        if (BPT.CheckingNode) {
            if (this.count == 0) {
                BPT.error("Node is empty - can't shift a slot out", new Object[0]);
            }
            if (this.isFull()) {
                BPT.error("Destination node is full", new Object[0]);
            }
        }
        Record r = node.records.getLow();
        this.records.add(splitKey);
        node.records.shiftDown(0);
        this.ptrs.shiftLeft(node.ptrs);
        ++this.count;
        --node.count;
        return r;
    }

    private void shuffleDown(int x) {
        if (BPT.logging(log)) {
            BPT.log(log, "ShuffleDown: i=%d count=%d MaxRec=%d", x, this.count, this.maxRecords());
            BPT.log(log, "ShuffleDown >> %s", this);
        }
        if (BPT.CheckingNode && x >= this.count) {
            BPT.error("shuffleDown out of bounds", new Object[0]);
        }
        if (x == this.count - 1) {
            this.records.removeTop();
            this.ptrs.removeTop();
            --this.count;
            if (BPT.logging(log)) {
                BPT.log(log, "shuffleDown << Clear top", new Object[0]);
                BPT.log(log, "shuffleDown << %s", this);
            }
            this.internalCheckNode();
            return;
        }
        this.records.shiftDown(x);
        this.ptrs.shiftDown(x + 1);
        --this.count;
        if (BPT.logging(log)) {
            BPT.log(log, "shuffleDown << %s", this);
        }
        this.internalCheckNode();
    }

    private static final BPTreeNode cast(BPTreePage other) {
        try {
            return (BPTreeNode)other;
        }
        catch (ClassCastException ex) {
            BPT.error("Wrong type: " + other, new Object[0]);
            return null;
        }
    }

    final int findSlot(Record rec) {
        int x = this.records.find(rec);
        return x;
    }

    final boolean isRoot() {
        return this.parent == -2;
    }

    private Record keyRecord(Record record) {
        return this.bpTree.getRecordFactory().createKeyOnly(record);
    }

    private final int maxRecords() {
        return this.params.MaxRec;
    }

    @Override
    final boolean isFull() {
        if (BPT.CheckingNode && this.count > this.maxRecords()) {
            BPT.error("isFull: Moby block: %s", this);
        }
        return this.count >= this.maxRecords();
    }

    @Override
    final boolean hasAnyKeys() {
        if (this.count > 0) {
            return true;
        }
        if (!this.isRoot()) {
            return false;
        }
        BPTreePage page = this.get(0);
        boolean b = page.hasAnyKeys();
        page.release();
        return b;
    }

    @Override
    final boolean isMinSize() {
        int min2 = this.params.getMinRec();
        if (BPT.CheckingNode && this.count < min2) {
            BPT.error("isMinSize: Dwarf block: %s", this);
        }
        return this.count <= min2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.isLeaf) {
            b.append("LEAF: ");
        } else {
            b.append("NODE: ");
        }
        String labelStr = "??";
        if (this.parent >= 0) {
            labelStr = Integer.toString(this.parent);
        } else if (this.parent == -2) {
            labelStr = "root";
        }
        if (this.isLeaf) {
            labelStr = labelStr + "/leaf";
        }
        b.append(String.format("%d [%s] (size %d) -- ", this.getId(), labelStr, this.count));
        for (int i = 0; i < this.maxRecords(); ++i) {
            b.append(this.childStr(i));
            b.append(" (");
            b.append(this.recstr(this.records, i));
            b.append(") ");
        }
        b.append(this.childStr(this.params.HighPtr));
        return b.toString();
    }

    @Override
    protected String typeMark() {
        String mark;
        String string = mark = this.isLeaf() ? "Leaf" : "Node";
        if (this.isRoot()) {
            mark = mark + "/Root";
        }
        return mark;
    }

    private final String recstr(RecordBuffer records, int idx) {
        if (records.isClear(idx)) {
            return "----";
        }
        Record r = records._get(idx);
        return r.toString();
    }

    public void dump() {
        boolean b = BPT.Logging;
        BPT.Logging = false;
        try {
            this.dump(IndentedWriter.stdout);
        }
        finally {
            BPT.Logging = b;
        }
    }

    public void dump(IndentedWriter out) {
        this.output(out);
        out.ensureStartOfLine();
        out.flush();
    }

    public String dumpToString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output(buff);
        return buff.asString();
    }

    @Override
    public void output(IndentedWriter out) {
        out.print(this.toString());
        out.incIndent();
        for (int i = 0; i < this.count + 1; ++i) {
            out.println();
            BPTreePage page = this.get(i);
            page.output(out);
            page.release();
        }
        out.decIndent();
    }

    private String childStr(int i) {
        if (i >= this.ptrs.size()) {
            return "*";
        }
        int x = this.ptrs.get(i);
        return Integer.toString(x);
    }

    private final void internalCheckNode() {
        if (BPT.CheckingNode) {
            this.checkNode(null, null);
        }
    }

    private final void internalCheckNodeDeep() {
    }

    @Override
    final void checkNode() {
        this.checkNode(null, null);
    }

    @Override
    final void checkNodeDeep() {
        if (this.isRoot() && this.parent != -2) {
            BPT.error("Root parent is wrong", new Object[0]);
        }
        this.checkNodeDeep(null, null);
    }

    private final void checkNode(Record min2, Record max2) {
        int i;
        int id = this.getId();
        if (this.count != this.records.size()) {
            BPT.error("Inconsistent: id=%d, count=%d, records.size()=%d : %s", id, this.count, this.records.size(), this);
        }
        if (!this.isLeaf && this.count + 1 != this.ptrs.size()) {
            BPT.error("Inconsistent: id=%d, count+1=%d, ptrs.size()=%d; %s", id, this.count + 1, this.ptrs.size(), this);
        }
        if (!this.isRoot() && this.count < this.params.MinRec) {
            BPT.error("Runt node: %s", this);
        }
        if (!this.isRoot() && this.count > this.maxRecords()) {
            BPT.error("Over full node: %s", this);
        }
        if (!this.isLeaf && this.parent == id) {
            BPT.error("Parent same as id: %s", this);
        }
        Record k = min2;
        for (i = 0; i < this.count; ++i) {
            if (this.records.get(i) == null) {
                BPT.error("Node: %d : Invalid record @%d :: %s", id, i, this);
            }
            if (k != null && Record.keyGT(k, this.records.get(i))) {
                Record r = this.records.get(i);
                BPT.error("Node: %d: Not sorted (%d) (%s, %s) :: %s ", id, i, k, r, this);
            }
            k = this.records.get(i);
        }
        if (k != null && max2 != null && Record.keyGT(k, max2)) {
            BPT.error("Node: %d - Record is too high (max=%s):: %s", id, max2, this);
        }
        if (SystemIndex.getNullOut()) {
            for (i = this.count; i < this.maxRecords(); ++i) {
                if (this.records.isClear(i)) continue;
                BPT.error("Node: %d - not clear (idx=%d) :: %s", id, i, this);
            }
        }
        for (i = 0; i < this.count + 1; ++i) {
            if (this.ptrs.get(i) >= 0) continue;
            BPT.error("Node: %d: Invalid child pointer @%d :: %s", id, i, this);
        }
        if (SystemIndex.getNullOut()) {
            int x = this.params.MaxPtr;
            while (i < x) {
                if (!this.ptrs.isClear(i)) {
                    BPT.error("Node: %d: Unexpected pointer @%d :: %s", id, i, this);
                }
                ++i;
            }
        }
    }

    private void checkNodeDeep(Record min2, Record max2) {
        this.checkNode(min2, max2);
        int id = this.getId();
        int limit = this.count == 0 ? 0 : this.count + 1;
        for (int i = 0; i < limit; ++i) {
            Record min1 = min2;
            Record max1 = max2;
            BPTreePage n = this.get(i);
            if (i != this.count) {
                Record keySubTree = n.getHighRecord();
                Record keyHere = this.records.get(i);
                if (keySubTree == null) {
                    BPT.error("Node: %d: Can't get high record from %d", id, n.getId());
                }
                if (keySubTree.getKey() == null) {
                    BPT.error("Node: %d: Can't get high record is missing it's key from %d", id, n.getId());
                }
                if (keyHere == null) {
                    BPT.error("Node: %d: record is null", id);
                }
                if (keyHere.getKey() == null) {
                    BPT.error("Node: %d: Record key is null", id);
                }
                if (Record.keyGT(keySubTree, keyHere)) {
                    BPT.error("Node: %d: Child key %s is greater than this key %s", id, keySubTree, keyHere);
                }
                Record keyMax = n.maxRecord();
                Record keyMin = n.internalMinRecord(null);
                if (Record.keyNE(keyHere, keyMax)) {
                    BPT.error("Node: %d: Key %s is not the max [%s] of the sub-tree idx=%d", id, keyHere, keyMax, i);
                }
                if (min2 != null && Record.keyGT(min2, keyMin)) {
                    BPT.error("Node: %d: Minimun for this node should be %s but it's %s", id, min2, keyMin);
                }
                if (max2 != null && Record.keyLT(max2, keyMax)) {
                    BPT.error("Node: %d: Maximum for this node should be %s but it's %s", id, max2, keyMax);
                }
                if (min2 != null && Record.keyGT(min2, keyHere)) {
                    BPT.error("Node: %d: Key too small: %s - min should be %s", id, keyHere, min2);
                }
                if (max2 != null && Record.keyLT(max2, keyHere)) {
                    BPT.error("Node: %d: Key too large: %s - max should be %s", id, keyHere, max2);
                }
            }
            if (!(n instanceof BPTreeNode)) {
                n.checkNodeDeep();
                n.release();
                continue;
            }
            if (this.isLeaf) {
                if (!this.bpTree.getRecordsMgr().getBlockMgr().valid(this.ptrs.get(i))) {
                    BPT.error("Node: %d: Dangling ptr (records) in block @%d :: %s", id, i, this);
                }
            } else if (!this.bpTree.getNodeManager().valid(this.ptrs.get(i))) {
                BPT.error("Node: %d: Dangling ptr in block @%d :: %s", id, i, this);
            }
            if (i == 0) {
                max1 = this.records.get(0);
            } else if (i == this.count) {
                min1 = this.records.get(this.count - 1);
                max1 = null;
            } else {
                min1 = this.records.get(i - 1);
                max1 = this.records.get(i);
            }
            ((BPTreeNode)n).checkNodeDeep(min1, max1);
            n.release();
        }
    }
}

