/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.block.FileMode;
import org.apache.jena.dboe.sys.Sys;

public class SystemIndex {
    public static final int SizeOfPointer = 4;
    public static final boolean is64bitSystem = Sys.is64bitSystem;
    public static final int BlockSize = 8192;
    public static final int BlockSizeTest = 1024;
    public static final int BlockSizeTestMem = 500;
    public static final int OrderMem = 5;
    public static final int SegmentSize = 0x800000;
    public static final int Node2NodeIdCacheSize = SystemIndex.intValue("Node2NodeIdCacheSize", is64bitSystem ? 100000 : 50000);
    public static final int NodeId2NodeCacheSize = SystemIndex.intValue("NodeId2NodeCacheSize", is64bitSystem ? 500000 : 50000);
    public static final int NodeMissCacheSize = 100;
    public static final int BlockWriteCacheSize = SystemIndex.intValue("BlockWriteCacheSize", 2000);
    public static final int BlockReadCacheSize = SystemIndex.intValue("BlockReadCacheSize", 10000);
    public static boolean NullOut = false;
    public static final byte FillByte = -1;
    public static boolean Checking = false;
    private static FileMode fileMode = null;

    public static void init() {
    }

    private static int intValue(String name, int dft) {
        return dft;
    }

    public static void setNullOut(boolean nullOut) {
        NullOut = nullOut;
    }

    public static boolean getNullOut() {
        return NullOut;
    }

    public static FileMode fileMode() {
        if (fileMode == null) {
            fileMode = SystemIndex.determineFileMode();
        }
        return fileMode;
    }

    public static void setFileMode(FileMode newFileMode) {
        if (fileMode != null) {
            Sys.log.warn("System file mode already determined - setting it has no effect");
            return;
        }
        fileMode = newFileMode;
    }

    static void internalSetFileMode(FileMode newFileMode) {
        fileMode = newFileMode;
    }

    private static FileMode determineFileMode() {
        String x = "default";
        if (x.equalsIgnoreCase("direct")) {
            Sys.syslog.info("File mode: direct (forced)");
            return FileMode.direct;
        }
        if (x.equalsIgnoreCase("mapped")) {
            Sys.syslog.info("File mode: mapped (forced)");
            return FileMode.mapped;
        }
        if (x.equalsIgnoreCase("default")) {
            if (is64bitSystem) {
                Sys.syslog.debug("File mode: Mapped");
                return FileMode.mapped;
            }
            Sys.syslog.debug("File mode: Direct");
            return FileMode.direct;
        }
        throw new DBOpEnvException("Unrecognized file mode (not one of 'default', 'direct' or 'mapped': " + x);
    }
}

