/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;

public class PrefixMapOverPrefixMapI
extends PrefixMapBase
implements PrefixMap {
    private final PrefixMapI pmapi;

    public static PrefixMap create(PrefixMapI pmap) {
        return new PrefixMapOverPrefixMapI(pmap);
    }

    private PrefixMapOverPrefixMapI(PrefixMapI pmapi) {
        this.pmapi = pmapi;
    }

    private static IRI iri(String iriStr) {
        return IRIResolver.iriFactory().create(iriStr);
    }

    private static String str(IRI iri2) {
        return iri2.toString();
    }

    @Override
    public Map<String, IRI> getMapping() {
        Map<String, IRI> map = this.pmapi.stream().collect(Collectors.toMap(e2 -> e2.getPrefix(), e2 -> PrefixMapOverPrefixMapI.iri(e2.getUri())));
        return map;
    }

    @Override
    public void add(String prefix, IRI iri2) {
        this.pmapi.add(prefix, PrefixMapOverPrefixMapI.str(iri2));
    }

    @Override
    public void delete(String prefix) {
        this.pmapi.delete(prefix);
    }

    @Override
    public void clear() {
        this.pmapi.clear();
    }

    @Override
    public boolean contains(String prefix) {
        return this.pmapi.containPrefix(prefix);
    }

    @Override
    public String abbreviate(String uriStr) {
        return this.pmapi.abbreviate(uriStr);
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        return this.pmapi.abbrev(uriStr);
    }

    @Override
    public String expand(String prefix, String localName) {
        return this.pmapi.expand(prefix, localName);
    }

    @Override
    public boolean isEmpty() {
        return this.pmapi.isEmpty();
    }

    @Override
    public int size() {
        return this.pmapi.size();
    }
}

