/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.block.BlockException;
import org.apache.jena.dboe.base.file.BlockAccess;
import org.apache.jena.dboe.sys.FileLib;
import org.apache.jena.dboe.sys.Sys;
import org.slf4j.Logger;

public abstract class BlockAccessBase
implements BlockAccess {
    protected final int blockSize;
    protected FileChannel file;
    protected final String filename;
    protected final String label;
    protected final AtomicLong seq;
    protected long numFileBlocks = -1L;

    public BlockAccessBase(String filename, int blockSize) {
        this.filename = filename;
        this.file = FileLib.openManaged(filename);
        this.blockSize = blockSize;
        this.label = BlockAccessBase.label(filename);
        long filesize = FileLib.size(this.file);
        long longBlockSize = blockSize;
        this.numFileBlocks = filesize / longBlockSize;
        this.seq = new AtomicLong(this.numFileBlocks);
        if (this.numFileBlocks > Integer.MAX_VALUE) {
            this.getLog().warn(String.format("File size (%d) exceeds tested block number limits (%d)", filesize, blockSize));
        }
        if (filesize % longBlockSize != 0L) {
            throw new BlockException(String.format("File size (%d) not a multiple of blocksize (%d)", filesize, blockSize));
        }
    }

    private static String label(String filename) {
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        String fn = j >= 0 ? filename.substring(j + 1) : filename;
        return fn;
    }

    protected abstract Logger getLog();

    @Override
    public final boolean isEmpty() {
        return this.numFileBlocks <= 0L;
    }

    protected final void writeNotification(Block block) {
    }

    protected final void overwriteNotification(Block block) {
        if (block.getId() >= this.numFileBlocks) {
            this.numFileBlocks = block.getId() + 1L;
            this.seq.set(this.numFileBlocks);
        }
    }

    protected final int allocateId() {
        this.checkIfClosed();
        int id = (int)this.seq.getAndIncrement();
        ++this.numFileBlocks;
        return id;
    }

    @Override
    public final long allocBoundary() {
        this.checkIfClosed();
        return this.seq.get();
    }

    @Override
    public final void resetAllocBoundary(long boundary) {
        this.checkIfClosed();
        this.seq.set(boundary);
        this._resetAllocBoundary(boundary);
    }

    protected abstract void _resetAllocBoundary(long var1);

    @Override
    public final synchronized boolean valid(long id) {
        if (id >= this.numFileBlocks) {
            return false;
        }
        return id >= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void check(long id) {
        if (id > Integer.MAX_VALUE) {
            throw new BlockException(String.format("BlockAccessBase: Id (%d) too large", id));
        }
        if (id < 0L || id >= this.numFileBlocks) {
            BlockAccessBase blockAccessBase = this;
            synchronized (blockAccessBase) {
                if (id < 0L || id >= this.numFileBlocks) {
                    throw new BlockException(String.format("BlockAccessBase: Bounds exception: %s: (%d,%d)", this.filename, id, this.numFileBlocks));
                }
            }
        }
    }

    protected final void check(Block block) {
        this.check(block.getId());
        ByteBuffer bb = block.getByteBuffer();
        if (bb.capacity() != this.blockSize) {
            throw new BlockException(String.format("BlockMgrFile: Wrong size block.  Expected=%d : actual=%d", this.blockSize, bb.capacity()));
        }
        if (bb.order() != Sys.NetworkOrder) {
            throw new BlockException("BlockMgrFile: Wrong byte order");
        }
    }

    protected void force() {
        FileLib.sync(this.file);
    }

    public final boolean isClosed() {
        return this.file == null;
    }

    protected final void checkIfClosed() {
        if (this.isClosed()) {
            this.getLog().error("File has been closed");
        }
    }

    protected abstract void _close();

    @Override
    public final void close() {
        this._close();
        FileLib.close(this.file);
        this.file = null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }
}

