/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.buffer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.lib.Alg;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.dboe.base.buffer.RecordBuffer;
import org.apache.jena.dboe.base.record.Record;
import org.apache.jena.dboe.base.record.RecordMapper;

public class RecordBufferIteratorMapper<X>
implements Iterator<X> {
    private static final int END = -99;
    private RecordBuffer rBuff;
    private int nextIdx;
    private X slot = null;
    private final byte[] keySlot;
    private final Record maxRec;
    private final Record minRec;
    private final RecordMapper<X> mapper;

    RecordBufferIteratorMapper(RecordBuffer rBuff, Record minRecord, Record maxRecord, int keyLen, RecordMapper<X> mapper) {
        this.rBuff = rBuff;
        this.mapper = mapper;
        this.keySlot = maxRecord == null ? null : new byte[keyLen];
        this.nextIdx = 0;
        this.minRec = minRecord;
        if (this.minRec != null) {
            this.nextIdx = rBuff.find(this.minRec);
            if (this.nextIdx < 0) {
                this.nextIdx = Alg.decodeIndex(this.nextIdx);
            }
        }
        this.maxRec = maxRecord;
    }

    private void finish() {
        this.rBuff = null;
        this.nextIdx = -99;
        this.slot = null;
    }

    @Override
    public boolean hasNext() {
        if (this.slot != null) {
            return true;
        }
        if (this.nextIdx < 0) {
            return false;
        }
        if (this.nextIdx >= this.rBuff.size()) {
            this.finish();
            return false;
        }
        this.slot = this.rBuff.access(this.nextIdx, this.keySlot, this.mapper);
        if (this.maxRec != null && Bytes.compare(this.keySlot, this.maxRec.getKey()) >= 0) {
            this.finish();
            return false;
        }
        ++this.nextIdx;
        return true;
    }

    @Override
    public X next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("RecordBufferIterator");
        }
        X r = this.slot;
        this.slot = null;
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("RecordBufferIterator.remove");
    }
}

