/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.org.pcollections;

import io.micrometer.shaded.org.pcollections.IntTreePMap;
import io.micrometer.shaded.org.pcollections.PVector;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TreePVector<E>
extends AbstractList<E>
implements PVector<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TreePVector<Object> EMPTY = new TreePVector(IntTreePMap.empty());
    private final IntTreePMap<E> map;

    public static <E> TreePVector<E> empty() {
        return EMPTY;
    }

    public static <E> TreePVector<E> singleton(E e2) {
        return TreePVector.empty().plus((Object)e2);
    }

    public static <E> TreePVector<E> from(Collection<? extends E> list) {
        if (list instanceof TreePVector) {
            return (TreePVector)list;
        }
        return TreePVector.empty().plusAll((Collection)list);
    }

    private TreePVector(IntTreePMap<E> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.map.get(index);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public TreePVector<E> subList(int start, int end) {
        int size = this.size();
        if (start < 0 || end > size || start > end) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == size) {
            return this;
        }
        if (start == end) {
            return TreePVector.empty();
        }
        return new TreePVector<E>(this.map.minusRange(end, size).minusRange(0, start).withKeysChangedAbove(start, -start));
    }

    @Override
    public TreePVector<E> plus(E e2) {
        return new TreePVector<E>(this.map.plus(this.size(), e2));
    }

    @Override
    public TreePVector<E> plus(int i, E e2) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector<E>(this.map.withKeysChangedAbove(i, 1).plus(i, e2));
    }

    @Override
    public TreePVector<E> minus(Object e2) {
        for (Map.Entry<Integer, E> entry : this.map.entrySet()) {
            if (!entry.getValue().equals(e2)) continue;
            return this.minus(entry.getKey());
        }
        return this;
    }

    @Override
    public TreePVector<E> minus(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new TreePVector(((IntTreePMap)this.map.minus(i)).withKeysChangedAbove(i, -1));
    }

    @Override
    public TreePVector<E> plusAll(Collection<? extends E> list) {
        PVector<E> result = this;
        for (E e2 : list) {
            result = result.plus((Object)e2);
        }
        return result;
    }

    @Override
    public TreePVector<E> minusAll(Collection<?> list) {
        PVector<E> result = this;
        for (Object e2 : list) {
            result = result.minus(e2);
        }
        return result;
    }

    @Override
    public TreePVector<E> plusAll(int i, Collection<? extends E> list) {
        if (i < 0 || i > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (list.size() == 0) {
            return this;
        }
        IntTreePMap<E> map = this.map.withKeysChangedAbove(i, list.size());
        for (E e2 : list) {
            map = map.plus(i++, e2);
        }
        return new TreePVector<E>(map);
    }

    @Override
    public PVector<E> with(int i, E e2) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        IntTreePMap<E> map = this.map.plus(i, e2);
        if (map == this.map) {
            return this;
        }
        return new TreePVector<E>(map);
    }
}

