/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.org.pcollections;

import io.micrometer.shaded.org.pcollections.Empty;
import io.micrometer.shaded.org.pcollections.POrderedSet;
import io.micrometer.shaded.org.pcollections.PSet;
import io.micrometer.shaded.org.pcollections.PVector;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class OrderedPSet<E>
extends AbstractSet<E>
implements POrderedSet<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final OrderedPSet<Object> EMPTY = new OrderedPSet(Empty.set(), Empty.vector());
    private PSet<E> contents;
    private PVector<E> order;

    public static <E> OrderedPSet<E> empty() {
        return EMPTY;
    }

    public static <E> OrderedPSet<E> from(Collection<? extends E> list) {
        if (list instanceof OrderedPSet) {
            return (OrderedPSet)list;
        }
        return OrderedPSet.empty().plusAll((Collection)list);
    }

    public static <E> OrderedPSet<E> singleton(E e2) {
        return OrderedPSet.empty().plus((Object)e2);
    }

    private OrderedPSet(PSet<E> c, PVector<E> o) {
        this.contents = c;
        this.order = o;
    }

    @Override
    public OrderedPSet<E> plus(E e2) {
        if (this.contents.contains(e2)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.plus(e2), this.order.plus(e2));
    }

    @Override
    public OrderedPSet<E> plusAll(Collection<? extends E> list) {
        POrderedSet<E> s = this;
        for (E e2 : list) {
            s = s.plus((Object)e2);
        }
        return s;
    }

    @Override
    public OrderedPSet<E> minus(Object e2) {
        if (!this.contents.contains(e2)) {
            return this;
        }
        return new OrderedPSet<E>(this.contents.minus(e2), this.order.minus(e2));
    }

    @Override
    public OrderedPSet<E> minusAll(Collection<?> list) {
        POrderedSet<E> s = this;
        for (Object e2 : list) {
            s = s.minus(e2);
        }
        return s;
    }

    @Override
    public Iterator<E> iterator() {
        return this.order.iterator();
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public E get(int index) {
        return this.order.get(index);
    }

    @Override
    public int indexOf(Object o) {
        if (!this.contents.contains(o)) {
            return -1;
        }
        return this.order.indexOf(o);
    }
}

