/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.logging.MetricsTurboFilter;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

@NonNullApi
@NonNullFields
public class LogbackMetrics
implements MeterBinder,
AutoCloseable {
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private final Map<MeterRegistry, MetricsTurboFilter> metricsTurboFilters = new ConcurrentHashMap<MeterRegistry, MetricsTurboFilter>();

    public LogbackMetrics() {
        this(Collections.emptyList());
    }

    public LogbackMetrics(Iterable<Tag> tags) {
        this(tags, (LoggerContext)LoggerFactory.getILoggerFactory());
    }

    public LogbackMetrics(Iterable<Tag> tags, LoggerContext context2) {
        this.tags = tags;
        this.loggerContext = context2;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        MetricsTurboFilter filter = new MetricsTurboFilter(registry, this.tags);
        this.metricsTurboFilters.put(registry, filter);
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    public static void ignoreMetrics(Runnable r) {
        ignoreMetrics.set(true);
        r.run();
        ignoreMetrics.remove();
    }

    @Override
    public void close() {
        for (MetricsTurboFilter metricsTurboFilter : this.metricsTurboFilters.values()) {
            this.loggerContext.getTurboFilterList().remove((Object)metricsTurboFilter);
        }
    }
}

