/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.text.ParseException;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.WKTReader;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsPoint;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;

@Deprecated
public class JtsWKTReaderShapeParser
extends WKTReader {
    public JtsWKTReaderShapeParser(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
    }

    @Override
    public Shape parseIfSupported(String wktString) throws ParseException {
        return this.parseIfSupported(wktString, new com.vividsolutions.jts.io.WKTReader(this.getShapeFactory().getGeometryFactory()));
    }

    private JtsShapeFactory getShapeFactory() {
        return (JtsShapeFactory)this.shapeFactory;
    }

    protected Shape parseIfSupported(String str2, com.vividsolutions.jts.io.WKTReader reader) throws ParseException {
        try {
            Geometry geom = reader.read(str2);
            this.checkCoordinates(geom);
            if (geom instanceof Point) {
                Point ptGeom = (Point)geom;
                if (this.getShapeFactory().useJtsPoint()) {
                    return new JtsPoint(ptGeom, (JtsSpatialContext)this.ctx);
                }
                return this.getShapeFactory().pointXY(ptGeom.getX(), ptGeom.getY());
            }
            if (geom.isRectangle()) {
                return this.getShapeFactory().makeRectFromRectangularPoly(geom);
            }
            return this.getShapeFactory().makeShapeFromGeometry(geom);
        }
        catch (InvalidShapeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new InvalidShapeException("error reading WKT: " + e3.toString(), e3);
        }
    }

    protected void checkCoordinates(Geometry geom) {
        geom.apply(new CoordinateSequenceFilter(){
            boolean changed = false;

            public void filter(CoordinateSequence seq2, int i) {
                double xNorm;
                double x = seq2.getX(i);
                double y = seq2.getY(i);
                if (JtsWKTReaderShapeParser.this.ctx.isGeo() && JtsWKTReaderShapeParser.this.ctx.isNormWrapLongitude() && Double.compare(x, xNorm = DistanceUtils.normLonDEG(x)) != 0) {
                    this.changed = true;
                    seq2.setOrdinate(i, 0, xNorm);
                }
                JtsWKTReaderShapeParser.this.ctx.verifyX(x);
                JtsWKTReaderShapeParser.this.ctx.verifyY(y);
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return this.changed;
            }
        });
    }
}

