/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Iterator;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.impl.BufferedLine;
import org.locationtech.spatial4j.shape.impl.BufferedLineString;

public class WKTWriter
implements ShapeWriter {
    @Override
    public String getFormatName() {
        return "WKT";
    }

    protected StringBuilder append(StringBuilder buffer, Point p, NumberFormat nf) {
        return buffer.append(nf.format(p.getX())).append(' ').append(nf.format(p.getY()));
    }

    @Override
    public String toString(Shape shape) {
        NumberFormat nf = LegacyShapeWriter.makeNumberFormat(6);
        if (shape instanceof Point) {
            StringBuilder buffer = new StringBuilder();
            return this.append(buffer.append("POINT ("), (Point)shape, nf).append(")").toString();
        }
        if (shape instanceof Rectangle) {
            NumberFormat nfMIN = nf;
            NumberFormat nfMAX = LegacyShapeWriter.makeNumberFormat(6);
            nfMIN.setRoundingMode(RoundingMode.FLOOR);
            nfMAX.setRoundingMode(RoundingMode.CEILING);
            Rectangle rect = (Rectangle)shape;
            return "ENVELOPE (" + nfMIN.format(rect.getMinX()) + ", " + nfMAX.format(rect.getMaxX()) + ", " + nfMAX.format(rect.getMaxY()) + ", " + nfMIN.format(rect.getMinY()) + ")";
        }
        if (shape instanceof Circle) {
            Circle c = (Circle)shape;
            StringBuilder str2 = new StringBuilder();
            str2.append("BUFFER (POINT (").append(nf.format(c.getCenter().getX())).append(" ").append(nf.format(c.getCenter().getY())).append("), ").append(nf.format(c.getRadius())).append(")");
            return str2.toString();
        }
        if (shape instanceof BufferedLineString) {
            BufferedLineString line = (BufferedLineString)shape;
            StringBuilder str3 = new StringBuilder();
            double buf = line.getBuf();
            if (buf > 0.0) {
                str3.append("BUFFER (");
            }
            str3.append("LINESTRING (");
            Iterator iter = line.getSegments().iterator();
            while (iter.hasNext()) {
                BufferedLine seg = (BufferedLine)iter.next();
                this.append(str3, seg.getA(), nf).append(", ");
                if (iter.hasNext()) continue;
                this.append(str3, seg.getB(), nf);
            }
            str3.append(")");
            if (buf > 0.0) {
                str3.append(", ").append(nf.format(buf)).append(")");
            }
            return str3.toString();
        }
        if (shape instanceof ShapeCollection) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("GEOMETRYCOLLECTION (");
            boolean first = true;
            for (Shape sub : ((ShapeCollection)shape).getShapes()) {
                if (!first) {
                    buffer.append(",");
                }
                buffer.append(this.toString(sub));
                first = false;
            }
            buffer.append(")");
            return buffer.toString();
        }
        return LegacyShapeWriter.writeShape(shape, nf);
    }

    @Override
    public void write(Writer output, Shape shape) throws IOException {
        output.append(this.toString(shape));
    }
}

