/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.OnePointsBuilder;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;

public class WKTReader
implements ShapeReader {
    protected final SpatialContext ctx;
    protected final ShapeFactory shapeFactory;

    public WKTReader(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
        this.shapeFactory = ctx.getShapeFactory();
    }

    public Shape parse(String wktString) throws ParseException, InvalidShapeException {
        Shape shape = this.parseIfSupported(wktString);
        if (shape != null) {
            return shape;
        }
        String shortenedString = wktString.length() <= 128 ? wktString : wktString.substring(0, 125) + "...";
        throw new ParseException("Unknown Shape definition [" + shortenedString + "]", 0);
    }

    public Shape parseIfSupported(String wktString) throws ParseException, InvalidShapeException {
        State state = this.newState(wktString);
        state.nextIfWhitespace();
        if (state.eof()) {
            return null;
        }
        if (!Character.isLetter(state.rawString.charAt(state.offset))) {
            return null;
        }
        String shapeType = state.nextWord();
        Shape result = null;
        try {
            result = this.parseShapeByType(state, shapeType);
        }
        catch (ParseException | InvalidShapeException e2) {
            throw e2;
        }
        catch (IllegalArgumentException e3) {
            throw new InvalidShapeException(e3.getMessage(), e3);
        }
        catch (Exception e4) {
            ParseException pe = new ParseException(e4.toString(), state.offset);
            pe.initCause(e4);
            throw pe;
        }
        if (result != null && !state.eof()) {
            throw new ParseException("end of shape expected", state.offset);
        }
        return result;
    }

    protected State newState(String wktString) {
        return new State(wktString);
    }

    protected Shape parseShapeByType(State state, String shapeType) throws ParseException {
        assert (Character.isLetter(shapeType.charAt(0))) : "Shape must start with letter: " + shapeType;
        if (shapeType.equalsIgnoreCase("POINT")) {
            return this.parsePointShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTIPOINT")) {
            return this.parseMultiPointShape(state);
        }
        if (shapeType.equalsIgnoreCase("ENVELOPE")) {
            return this.parseEnvelopeShape(state);
        }
        if (shapeType.equalsIgnoreCase("LINESTRING")) {
            return this.parseLineStringShape(state);
        }
        if (shapeType.equalsIgnoreCase("POLYGON")) {
            return this.parsePolygonShape(state);
        }
        if (shapeType.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.parseGeometryCollectionShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTILINESTRING")) {
            return this.parseMultiLineStringShape(state);
        }
        if (shapeType.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.parseMulitPolygonShape(state);
        }
        if (shapeType.equalsIgnoreCase("BUFFER")) {
            return this.parseBufferShape(state);
        }
        return null;
    }

    protected Shape parseBufferShape(State state) throws ParseException {
        state.nextExpect('(');
        Shape shape = this.shape(state);
        state.nextExpect(',');
        double distance = this.shapeFactory.normDist(state.nextDouble());
        state.nextExpect(')');
        return shape.getBuffered(distance, this.ctx);
    }

    protected Shape parsePointShape(State state) throws ParseException {
        if (state.nextIfEmptyAndSkipZM()) {
            return this.shapeFactory.pointXY(Double.NaN, Double.NaN);
        }
        state.nextExpect('(');
        OnePointsBuilder onePointsBuilder = new OnePointsBuilder(this.shapeFactory);
        this.point(state, onePointsBuilder);
        state.nextExpect(')');
        return onePointsBuilder.getPoint();
    }

    protected Shape parseMultiPointShape(State state) throws ParseException {
        ShapeFactory.MultiPointBuilder builder = this.shapeFactory.multiPoint();
        if (state.nextIfEmptyAndSkipZM()) {
            return builder.build();
        }
        state.nextExpect('(');
        do {
            boolean openParen = state.nextIf('(');
            this.point(state, builder);
            if (!openParen) continue;
            state.nextExpect(')');
        } while (state.nextIf(','));
        state.nextExpect(')');
        return builder.build();
    }

    protected Shape parseEnvelopeShape(State state) throws ParseException {
        state.nextExpect('(');
        double x1 = state.nextDouble();
        state.nextExpect(',');
        double x2 = state.nextDouble();
        state.nextExpect(',');
        double y2 = state.nextDouble();
        state.nextExpect(',');
        double y1 = state.nextDouble();
        state.nextExpect(')');
        return this.shapeFactory.rect(this.shapeFactory.normX(x1), this.shapeFactory.normX(x2), this.shapeFactory.normY(y1), this.shapeFactory.normY(y2));
    }

    protected Shape parseLineStringShape(State state) throws ParseException {
        ShapeFactory.LineStringBuilder lineStringBuilder = this.shapeFactory.lineString();
        if (state.nextIfEmptyAndSkipZM()) {
            return lineStringBuilder.build();
        }
        return this.pointList(state, lineStringBuilder).build();
    }

    protected Shape parseMultiLineStringShape(State state) throws ParseException {
        ShapeFactory.MultiLineStringBuilder multiLineStringBuilder = this.shapeFactory.multiLineString();
        if (!state.nextIfEmptyAndSkipZM()) {
            state.nextExpect('(');
            do {
                multiLineStringBuilder.add(this.pointList(state, multiLineStringBuilder.lineString()));
            } while (state.nextIf(','));
            state.nextExpect(')');
        }
        return multiLineStringBuilder.build();
    }

    protected Shape parsePolygonShape(State state) throws ParseException {
        ShapeFactory.PolygonBuilder polygonBuilder = this.shapeFactory.polygon();
        if (!state.nextIfEmptyAndSkipZM()) {
            polygonBuilder = this.polygon(state, polygonBuilder);
        }
        return polygonBuilder.buildOrRect();
    }

    protected Shape parseMulitPolygonShape(State state) throws ParseException {
        ShapeFactory.MultiPolygonBuilder multiPolygonBuilder = this.shapeFactory.multiPolygon();
        if (!state.nextIfEmptyAndSkipZM()) {
            state.nextExpect('(');
            do {
                multiPolygonBuilder.add(this.polygon(state, multiPolygonBuilder.polygon()));
            } while (state.nextIf(','));
            state.nextExpect(')');
        }
        return multiPolygonBuilder.build();
    }

    protected Shape parseGeometryCollectionShape(State state) throws ParseException {
        ShapeFactory.MultiShapeBuilder<Shape> multiShapeBuilder = this.shapeFactory.multiShape(Shape.class);
        if (state.nextIfEmptyAndSkipZM()) {
            return multiShapeBuilder.build();
        }
        state.nextExpect('(');
        do {
            multiShapeBuilder.add(this.shape(state));
        } while (state.nextIf(','));
        state.nextExpect(')');
        return multiShapeBuilder.build();
    }

    protected Shape shape(State state) throws ParseException {
        String type = state.nextWord();
        Shape shape = this.parseShapeByType(state, type);
        if (shape == null) {
            throw new ParseException("Shape of type " + type + " is unknown", state.offset);
        }
        return shape;
    }

    protected <B extends ShapeFactory.PointsBuilder> B pointList(State state, B pointsBuilder) throws ParseException {
        state.nextExpect('(');
        do {
            this.point(state, pointsBuilder);
        } while (state.nextIf(','));
        state.nextExpect(')');
        return pointsBuilder;
    }

    protected ShapeFactory.PointsBuilder point(State state, ShapeFactory.PointsBuilder pointsBuilder) throws ParseException {
        double x = state.nextDouble();
        double y = state.nextDouble();
        state.skipNextDoubles();
        pointsBuilder.pointXY(this.shapeFactory.normX(x), this.shapeFactory.normY(y));
        return pointsBuilder;
    }

    protected ShapeFactory.PolygonBuilder polygon(State state, ShapeFactory.PolygonBuilder polygonBuilder) throws ParseException {
        state.nextExpect('(');
        this.pointList(state, polygonBuilder);
        while (state.nextIf(',')) {
            ShapeFactory.PolygonBuilder.HoleBuilder holeBuilder = polygonBuilder.hole();
            this.pointList(state, holeBuilder);
            holeBuilder.endHole();
        }
        state.nextExpect(')');
        return polygonBuilder;
    }

    @Override
    public String getFormatName() {
        return "WKT";
    }

    static String readString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[1024];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        return buffer.toString();
    }

    @Override
    public Shape read(Reader reader) throws IOException, ParseException {
        return this.parse(WKTReader.readString(reader));
    }

    @Override
    public Shape read(Object value) throws IOException, ParseException, InvalidShapeException {
        return this.parse(value.toString());
    }

    @Override
    public Shape readIfSupported(Object value) throws InvalidShapeException {
        try {
            return this.parseIfSupported(value.toString());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public class State {
        public String rawString;
        public int offset;
        public String dimension;

        public State(String rawString) {
            this.rawString = rawString;
        }

        public SpatialContext getCtx() {
            return WKTReader.this.ctx;
        }

        public WKTReader getParser() {
            return WKTReader.this;
        }

        public String nextWord() throws ParseException {
            int startOffset = this.offset;
            while (this.offset < this.rawString.length() && Character.isJavaIdentifierPart(this.rawString.charAt(this.offset))) {
                ++this.offset;
            }
            if (startOffset == this.offset) {
                throw new ParseException("Word expected", startOffset);
            }
            String result = this.rawString.substring(startOffset, this.offset);
            this.nextIfWhitespace();
            return result;
        }

        public boolean nextIfEmptyAndSkipZM() throws ParseException {
            if (this.eof()) {
                return false;
            }
            char c = this.rawString.charAt(this.offset);
            if (c == '(' || !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            String word = this.nextWord();
            if (word.equalsIgnoreCase("EMPTY")) {
                return true;
            }
            this.dimension = word;
            if (this.eof()) {
                return false;
            }
            c = this.rawString.charAt(this.offset);
            if (c == '(' || !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            word = this.nextWord();
            if (word.equalsIgnoreCase("EMPTY")) {
                return true;
            }
            throw new ParseException("Expected EMPTY because found dimension; but got [" + word + "]", this.offset);
        }

        public double nextDouble() throws ParseException {
            double result;
            int startOffset = this.offset;
            this.skipDouble();
            if (startOffset == this.offset) {
                throw new ParseException("Expected a number", this.offset);
            }
            try {
                result = Double.parseDouble(this.rawString.substring(startOffset, this.offset));
            }
            catch (Exception e2) {
                throw new ParseException(e2.toString(), this.offset);
            }
            this.nextIfWhitespace();
            return result;
        }

        public void skipDouble() {
            char c;
            int startOffset = this.offset;
            while (this.offset < this.rawString.length() && (Character.isDigit(c = this.rawString.charAt(this.offset)) || c == '.' || c == '-' || c == '+' || this.offset != startOffset && (c == 'e' || c == 'E'))) {
                ++this.offset;
            }
        }

        public void skipNextDoubles() {
            while (!this.eof()) {
                int startOffset = this.offset;
                this.skipDouble();
                if (startOffset == this.offset) {
                    return;
                }
                this.nextIfWhitespace();
            }
        }

        public void nextExpect(char expected) throws ParseException {
            if (this.eof()) {
                throw new ParseException("Expected [" + expected + "] found EOF", this.offset);
            }
            char c = this.rawString.charAt(this.offset);
            if (c != expected) {
                throw new ParseException("Expected [" + expected + "] found [" + c + "]", this.offset);
            }
            ++this.offset;
            this.nextIfWhitespace();
        }

        public final boolean eof() {
            return this.offset >= this.rawString.length();
        }

        public boolean nextIf(char expected) {
            if (!this.eof() && this.rawString.charAt(this.offset) == expected) {
                ++this.offset;
                this.nextIfWhitespace();
                return true;
            }
            return false;
        }

        public void nextIfWhitespace() {
            while (this.offset < this.rawString.length()) {
                if (!Character.isWhitespace(this.rawString.charAt(this.offset))) {
                    return;
                }
                ++this.offset;
            }
        }

        public String nextSubShapeString() throws ParseException {
            int startOffset = this.offset;
            int parenStack = 0;
            while (this.offset < this.rawString.length()) {
                char c = this.rawString.charAt(this.offset);
                if (c == ',') {
                    if (parenStack == 0) {
                        break;
                    }
                } else if (c == ')') {
                    if (parenStack == 0) break;
                    --parenStack;
                } else if (c == '(') {
                    ++parenStack;
                }
                ++this.offset;
            }
            if (parenStack != 0) {
                throw new ParseException("Unbalanced parenthesis", startOffset);
            }
            return this.rawString.substring(startOffset, this.offset);
        }
    }
}

