/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DisabledSessionException;
import org.apache.shiro.web.servlet.ShiroHttpSession;
import org.apache.shiro.web.util.WebUtils;

public class ShiroHttpServletRequest
extends HttpServletRequestWrapper {
    public static final String COOKIE_SESSION_ID_SOURCE = "cookie";
    public static final String URL_SESSION_ID_SOURCE = "url";
    public static final String REFERENCED_SESSION_ID = ShiroHttpServletRequest.class.getName() + "_REQUESTED_SESSION_ID";
    public static final String REFERENCED_SESSION_ID_IS_VALID = ShiroHttpServletRequest.class.getName() + "_REQUESTED_SESSION_ID_VALID";
    public static final String REFERENCED_SESSION_IS_NEW = ShiroHttpServletRequest.class.getName() + "_REFERENCED_SESSION_IS_NEW";
    public static final String REFERENCED_SESSION_ID_SOURCE = ShiroHttpServletRequest.class.getName() + "REFERENCED_SESSION_ID_SOURCE";
    public static final String IDENTITY_REMOVED_KEY = ShiroHttpServletRequest.class.getName() + "_IDENTITY_REMOVED_KEY";
    protected ServletContext servletContext = null;
    protected HttpSession session = null;
    protected boolean httpSessions = true;

    public ShiroHttpServletRequest(HttpServletRequest wrapped, ServletContext servletContext, boolean httpSessions) {
        super(wrapped);
        this.servletContext = servletContext;
        this.httpSessions = httpSessions;
    }

    public boolean isHttpSessions() {
        return this.httpSessions;
    }

    @Override
    public String getRemoteUser() {
        String remoteUser;
        Object scPrincipal = this.getSubjectPrincipal();
        if (scPrincipal != null) {
            if (scPrincipal instanceof String) {
                return (String)scPrincipal;
            }
            remoteUser = scPrincipal instanceof Principal ? ((Principal)scPrincipal).getName() : scPrincipal.toString();
        } else {
            remoteUser = super.getRemoteUser();
        }
        return remoteUser;
    }

    protected Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    protected Object getSubjectPrincipal() {
        Object userPrincipal = null;
        Subject subject = this.getSubject();
        if (subject != null) {
            userPrincipal = subject.getPrincipal();
        }
        return userPrincipal;
    }

    @Override
    public boolean isUserInRole(String s) {
        boolean inRole;
        Subject subject = this.getSubject();
        boolean bl = inRole = subject != null && subject.hasRole(s);
        if (!inRole) {
            inRole = super.isUserInRole(s);
        }
        return inRole;
    }

    @Override
    public Principal getUserPrincipal() {
        Object scPrincipal = this.getSubjectPrincipal();
        Principal userPrincipal = scPrincipal != null ? (scPrincipal instanceof Principal ? (Principal)scPrincipal : new ObjectPrincipal(scPrincipal)) : super.getUserPrincipal();
        return userPrincipal;
    }

    @Override
    public String getRequestedSessionId() {
        String requestedSessionId = null;
        if (this.isHttpSessions()) {
            requestedSessionId = super.getRequestedSessionId();
        } else {
            Object sessionId = this.getAttribute(REFERENCED_SESSION_ID);
            if (sessionId != null) {
                requestedSessionId = sessionId.toString();
            }
        }
        return requestedSessionId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public HttpSession getSession(boolean create) {
        if (this.isHttpSessions()) {
            HttpSession httpSession = super.getSession(false);
            if (httpSession != null) return httpSession;
            if (!create) return httpSession;
            if (!WebUtils._isSessionCreationEnabled(this)) throw this.newNoSessionCreationException();
            return super.getSession(create);
        }
        if (this.session != null) return this.session;
        boolean existing = this.getSubject().getSession(false) != null;
        Session shiroSession = this.getSubject().getSession(create);
        if (shiroSession == null) return this.session;
        this.session = new ShiroHttpSession(shiroSession, this, this.servletContext);
        if (existing) return this.session;
        this.setAttribute(REFERENCED_SESSION_IS_NEW, Boolean.TRUE);
        return this.session;
    }

    private DisabledSessionException newNoSessionCreationException() {
        String msg = "Session creation has been disabled for the current request.  This exception indicates that there is either a programming error (using a session when it should never be used) or that Shiro's configuration needs to be adjusted to allow Sessions to be created for the current request.  See the " + DisabledSessionException.class.getName() + " JavaDoc for more.";
        return new DisabledSessionException(msg);
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.isHttpSessions()) {
            return super.isRequestedSessionIdValid();
        }
        Boolean value = (Boolean)this.getAttribute(REFERENCED_SESSION_ID_IS_VALID);
        return value != null && value.equals(Boolean.TRUE);
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        if (this.isHttpSessions()) {
            return super.isRequestedSessionIdFromCookie();
        }
        String value = (String)this.getAttribute(REFERENCED_SESSION_ID_SOURCE);
        return value != null && value.equals(COOKIE_SESSION_ID_SOURCE);
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        if (this.isHttpSessions()) {
            return super.isRequestedSessionIdFromURL();
        }
        String value = (String)this.getAttribute(REFERENCED_SESSION_ID_SOURCE);
        return value != null && value.equals(URL_SESSION_ID_SOURCE);
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    private class ObjectPrincipal
    implements Principal {
        private Object object = null;

        public ObjectPrincipal(Object object) {
            this.object = object;
        }

        public Object getObject() {
            return this.object;
        }

        @Override
        public String getName() {
            return this.getObject().toString();
        }

        @Override
        public int hashCode() {
            return this.object.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ObjectPrincipal) {
                ObjectPrincipal op = (ObjectPrincipal)o;
                return this.getObject().equals(op.getObject());
            }
            return false;
        }

        @Override
        public String toString() {
            return this.object.toString();
        }
    }
}

