/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.SegmentCacheable;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.spatial.ShapeValues;
import org.apache.lucene.spatial.ShapeValuesSource;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class ShapeValuesPredicate
implements SegmentCacheable {
    private final ShapeValuesSource shapeValuesource;
    private final SpatialOperation op;
    private final Shape queryShape;

    public ShapeValuesPredicate(ShapeValuesSource shapeValuesource, SpatialOperation op, Shape queryShape) {
        this.shapeValuesource = shapeValuesource;
        this.op = op;
        this.queryShape = queryShape;
    }

    public String toString() {
        return this.shapeValuesource + " " + this.op + " " + this.queryShape;
    }

    public TwoPhaseIterator iterator(LeafReaderContext ctx, DocIdSetIterator approximation) throws IOException {
        final ShapeValues shapeValues = this.shapeValuesource.getValues(ctx);
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                return shapeValues.advanceExact(this.approximation.docID()) && ShapeValuesPredicate.this.op.evaluate(shapeValues.value(), ShapeValuesPredicate.this.queryShape);
            }

            @Override
            public float matchCost() {
                return 100.0f;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapeValuesPredicate that = (ShapeValuesPredicate)o;
        if (!this.shapeValuesource.equals(that.shapeValuesource)) {
            return false;
        }
        if (!this.op.equals(that.op)) {
            return false;
        }
        return this.queryShape.equals(that.queryShape);
    }

    public int hashCode() {
        int result = this.shapeValuesource.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        return result;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return this.shapeValuesource.isCacheable(ctx);
    }
}

