/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import java.util.Map;
import org.apache.lucene.spatial.spatial4j.Geo3dBinaryCodec;
import org.apache.lucene.spatial.spatial4j.Geo3dDistanceCalculator;
import org.apache.lucene.spatial.spatial4j.Geo3dShapeFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;

public class Geo3dSpatialContextFactory
extends SpatialContextFactory {
    private static final PlanetModel DEFAULT_PLANET_MODEL = PlanetModel.SPHERE;
    public PlanetModel planetModel;

    public Geo3dSpatialContextFactory() {
        this.binaryCodecClass = Geo3dBinaryCodec.class;
        this.shapeFactoryClass = Geo3dShapeFactory.class;
    }

    @Override
    public SpatialContext newSpatialContext() {
        if (this.planetModel == null) {
            this.planetModel = DEFAULT_PLANET_MODEL;
        }
        if (this.distCalc == null) {
            this.distCalc = new Geo3dDistanceCalculator(this.planetModel);
        }
        return new SpatialContext(this);
    }

    @Override
    protected void init(Map<String, String> args, ClassLoader classLoader) {
        this.initPlanetModel(args);
        super.init(args, classLoader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initPlanetModel(Map<String, String> args) {
        String planetModel = args.get("planetModel");
        if (planetModel != null) {
            if (planetModel.equalsIgnoreCase("sphere")) {
                this.planetModel = PlanetModel.SPHERE;
                return;
            } else {
                if (!planetModel.equalsIgnoreCase("wgs84")) throw new RuntimeException("Unknown planet model: " + planetModel);
                this.planetModel = PlanetModel.WGS84;
            }
            return;
        } else {
            this.planetModel = DEFAULT_PLANET_MODEL;
        }
    }

    @Override
    protected void initCalculator() {
        String calcStr = (String)this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equals("geo3d")) {
            this.distCalc = new Geo3dDistanceCalculator(this.planetModel);
        } else {
            super.initCalculator();
        }
    }
}

