/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoCircleFactory;
import org.apache.lucene.spatial3d.geom.GeoPointShapeFactory;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;

public class Geo3dCircleShape
extends Geo3dShape<GeoCircle>
implements Circle {
    public Geo3dCircleShape(GeoCircle shape, SpatialContext spatialcontext) {
        super(shape, spatialcontext);
    }

    @Override
    public void reset(double x, double y, double radiusDEG) {
        this.shape = GeoCircleFactory.makeGeoCircle(((GeoCircle)this.shape).getPlanetModel(), y * (Math.PI / 180), x * (Math.PI / 180), radiusDEG * (Math.PI / 180));
        this.center = null;
        this.boundingBox = null;
    }

    @Override
    public double getRadius() {
        return ((GeoCircle)this.shape).getRadius() * 57.29577951308232;
    }

    @Override
    public Point getCenter() {
        Point center = this.center;
        if (center == null) {
            this.center = center = new Geo3dPointShape(GeoPointShapeFactory.makeGeoPointShape(((GeoCircle)this.shape).getPlanetModel(), ((GeoCircle)this.shape).getCenter().getLatitude(), ((GeoCircle)this.shape).getCenter().getLongitude()), this.spatialcontext);
        }
        return center;
    }
}

