/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.spatial.prefix.ContainsPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.IntersectsPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.WithinPrefixTreeQuery;
import org.apache.lucene.spatial.prefix.tree.Cell;
import org.apache.lucene.spatial.prefix.tree.CellCanPrune;
import org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.lucene.spatial.query.UnsupportedSpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class RecursivePrefixTreeStrategy
extends PrefixTreeStrategy {
    protected int prefixGridScanLevel;
    protected boolean pruneLeafyBranches = true;
    protected boolean multiOverlappingIndexedShapes = true;

    public RecursivePrefixTreeStrategy(SpatialPrefixTree grid, String fieldName) {
        super(grid, fieldName);
        this.prefixGridScanLevel = grid.getMaxLevels() - 4;
    }

    public int getPrefixGridScanLevel() {
        return this.prefixGridScanLevel;
    }

    public void setPrefixGridScanLevel(int prefixGridScanLevel) {
        this.prefixGridScanLevel = prefixGridScanLevel;
    }

    public boolean isMultiOverlappingIndexedShapes() {
        return this.multiOverlappingIndexedShapes;
    }

    public void setMultiOverlappingIndexedShapes(boolean multiOverlappingIndexedShapes) {
        this.multiOverlappingIndexedShapes = multiOverlappingIndexedShapes;
    }

    public boolean isPruneLeafyBranches() {
        return this.pruneLeafyBranches;
    }

    public void setPruneLeafyBranches(boolean pruneLeafyBranches) {
        this.pruneLeafyBranches = pruneLeafyBranches;
    }

    @Override
    public String toString() {
        StringBuilder str2 = new StringBuilder(this.getClass().getSimpleName()).append('(');
        str2.append("SPG:(").append(this.grid.toString()).append(')');
        if (this.pointsOnly) {
            str2.append(",pointsOnly");
        }
        if (this.pruneLeafyBranches) {
            str2.append(",pruneLeafyBranches");
        }
        if (this.prefixGridScanLevel != this.grid.getMaxLevels() - 4) {
            str2.append(",prefixGridScanLevel:").append("" + this.prefixGridScanLevel);
        }
        if (!this.multiOverlappingIndexedShapes) {
            str2.append(",!multiOverlappingIndexedShapes");
        }
        return str2.append(')').toString();
    }

    @Override
    protected Iterator<Cell> createCellIteratorToIndex(Shape shape, int detailLevel, Iterator<Cell> reuse) {
        if (!this.pruneLeafyBranches || this.isGridAlignedShape(shape)) {
            return super.createCellIteratorToIndex(shape, detailLevel, reuse);
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(4096);
        this.recursiveTraverseAndPrune(this.grid.getWorldCell(), shape, detailLevel, cells);
        return cells.iterator();
    }

    private boolean recursiveTraverseAndPrune(Cell cell, Shape shape, int detailLevel, List<Cell> result) {
        if (cell.getLevel() == detailLevel) {
            cell.setLeaf();
        }
        if (cell.isLeaf()) {
            result.add(cell);
            return true;
        }
        if (cell.getLevel() != 0) {
            result.add(cell);
        }
        int leaves = 0;
        CellIterator subCells = cell.getNextLevelCells(shape);
        while (subCells.hasNext()) {
            Cell subCell = subCells.next();
            if (!this.recursiveTraverseAndPrune(subCell, shape, detailLevel, result)) continue;
            ++leaves;
        }
        if (!(cell instanceof CellCanPrune)) {
            return false;
        }
        if (leaves == ((CellCanPrune)cell).getSubCellsSize() && cell.getLevel() != 0) {
            do {
                result.remove(result.size() - 1);
            } while (--leaves > 0);
            cell.setLeaf();
            return true;
        }
        return false;
    }

    @Override
    public Query makeQuery(SpatialArgs args) {
        SpatialOperation op = args.getOperation();
        Shape shape = args.getShape();
        int detailLevel = this.grid.getLevelForDistance(args.resolveDistErr(this.ctx, this.distErrPct));
        if (op == SpatialOperation.Intersects) {
            if (this.isGridAlignedShape(args.getShape())) {
                return this.makeGridShapeIntersectsQuery(args.getShape());
            }
            return new IntersectsPrefixTreeQuery(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel);
        }
        if (op == SpatialOperation.IsWithin) {
            return new WithinPrefixTreeQuery(shape, this.getFieldName(), this.grid, detailLevel, this.prefixGridScanLevel, -1.0);
        }
        if (op == SpatialOperation.Contains) {
            return new ContainsPrefixTreeQuery(shape, this.getFieldName(), this.grid, detailLevel, this.multiOverlappingIndexedShapes);
        }
        throw new UnsupportedSpatialOperation(op);
    }

    protected boolean isGridAlignedShape(Shape shape) {
        return this.isPointShape(shape);
    }

    protected Query makeGridShapeIntersectsQuery(Shape gridShape) {
        assert (this.isGridAlignedShape(gridShape));
        if (this.isPointsOnly()) {
            CellIterator cellIterator = this.grid.getTreeCellIterator(gridShape, this.grid.getMaxLevels());
            Cell cell = (Cell)cellIterator.next();
            while (cellIterator.hasNext()) {
                int prevLevel = cell.getLevel();
                cell = (Cell)cellIterator.next();
                assert (prevLevel < cell.getLevel());
            }
            assert (cell.isLeaf());
            return new TermQuery(new Term(this.getFieldName(), cell.getTokenBytesWithLeaf(null)));
        }
        return new IntersectsPrefixTreeQuery(gridShape, this.getFieldName(), this.grid, this.getGrid().getMaxLevels(), this.getGrid().getMaxLevels() + 1);
    }
}

