/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public abstract class OffsetsEnum
implements Comparable<OffsetsEnum>,
Closeable {
    public static final OffsetsEnum EMPTY = new OffsetsEnum(){

        @Override
        public boolean nextPosition() throws IOException {
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int startOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int endOffset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int freq() throws IOException {
            return 0;
        }
    };

    @Override
    public int compareTo(OffsetsEnum other) {
        try {
            int cmp = Integer.compare(this.startOffset(), other.startOffset());
            if (cmp != 0) {
                return cmp;
            }
            BytesRef thisTerm = this.getTerm();
            BytesRef otherTerm = other.getTerm();
            if (thisTerm == null || otherTerm == null) {
                if (thisTerm == null && otherTerm == null) {
                    return 0;
                }
                if (thisTerm == null) {
                    return 1;
                }
                return -1;
            }
            return thisTerm.compareTo(otherTerm);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public abstract boolean nextPosition() throws IOException;

    public abstract int freq() throws IOException;

    public abstract BytesRef getTerm() throws IOException;

    public abstract int startOffset() throws IOException;

    public abstract int endOffset() throws IOException;

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        try {
            return name + "(term:" + this.getTerm().utf8ToString() + ")";
        }
        catch (Exception e2) {
            return name;
        }
    }

    public static class MultiOffsetsEnum
    extends OffsetsEnum {
        private final PriorityQueue<OffsetsEnum> queue = new PriorityQueue();
        private boolean started = false;

        public MultiOffsetsEnum(List<OffsetsEnum> inner) throws IOException {
            for (OffsetsEnum oe : inner) {
                if (!oe.nextPosition()) continue;
                this.queue.add(oe);
            }
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (!this.started) {
                this.started = true;
                return this.queue.size() > 0;
            }
            if (this.queue.size() > 0) {
                OffsetsEnum top = this.queue.poll();
                if (top.nextPosition()) {
                    this.queue.add(top);
                    return true;
                }
                top.close();
                return this.queue.size() > 0;
            }
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.queue.peek().getTerm();
        }

        @Override
        public int startOffset() throws IOException {
            return this.queue.peek().startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.queue.peek().endOffset();
        }

        @Override
        public int freq() throws IOException {
            return this.queue.peek().freq();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.queue);
        }
    }

    public static class OfPostings
    extends OffsetsEnum {
        private final BytesRef term;
        private final PostingsEnum postingsEnum;
        private final int freq;
        private int posCounter = -1;

        public OfPostings(BytesRef term, int freq, PostingsEnum postingsEnum) throws IOException {
            this.term = Objects.requireNonNull(term);
            this.postingsEnum = Objects.requireNonNull(postingsEnum);
            this.freq = freq;
            this.posCounter = this.postingsEnum.freq();
        }

        public OfPostings(BytesRef term, PostingsEnum postingsEnum) throws IOException {
            this(term, postingsEnum.freq(), postingsEnum);
        }

        public PostingsEnum getPostingsEnum() {
            return this.postingsEnum;
        }

        @Override
        public boolean nextPosition() throws IOException {
            if (this.posCounter > 0) {
                --this.posCounter;
                this.postingsEnum.nextPosition();
                return true;
            }
            return false;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.term;
        }

        @Override
        public int startOffset() throws IOException {
            return this.postingsEnum.startOffset();
        }

        @Override
        public int endOffset() throws IOException {
            return this.postingsEnum.endOffset();
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }
    }
}

