/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.Objects;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.TxnId;

public class IteratorTxnTracker<T>
extends IteratorWrapper<T> {
    private final TransactionalSystem txnSystem;
    private final TxnId txnId;

    public IteratorTxnTracker(Iterator<T> iterator, TransactionalSystem txnSystem, TxnId txnId) {
        super(iterator);
        this.txnSystem = Objects.requireNonNull(txnSystem, "TransactionalSystem");
        this.txnId = Objects.requireNonNull(txnId, "TxnId");
    }

    @Override
    public boolean hasNext() {
        this.check();
        return super.hasNext();
    }

    @Override
    public T next() {
        this.check();
        return super.next();
    }

    @Override
    public void remove() {
        this.check();
        super.remove();
    }

    private void check() {
        Transaction txn = this.txnSystem.getThreadTransaction();
        if (txn == null) {
            throw new TransactionException("Iterator used outside its original transaction");
        }
        if (txn != null && this.txnId.equals(txn.getTxnId())) {
            return;
        }
        throw new TransactionException("Iterator used inside a different transaction");
    }
}

